/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common;

import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class Util {
    public static boolean tryMoveToEntityLivingLongDist(Mob entSource, Entity entityTo, double moveSpeedAmp) {
        return Util.tryMoveToXYZLongDist(entSource, entityTo.blockPosition(), moveSpeedAmp);
    }

    public static boolean tryMoveToXYZLongDist(Mob ent, BlockPos pos, double moveSpeedAmp) {
        return Util.tryMoveToXYZLongDist(ent, pos.getX(), pos.getY(), pos.getZ(), moveSpeedAmp);
    }

    public static boolean tryMoveToXYZLongDist(Mob ent, int x, int y, int z, double moveSpeedAmp) {
        Level world = ent.level();
        boolean success = false;
        if (ent.getNavigation().isDone()) {
            double followDist;
            double distToPlayer = Util.getDistance((Entity)ent, x, y, z);
            if (distToPlayer <= (followDist = ent.getAttribute(Attributes.FOLLOW_RANGE).getValue())) {
                success = ent.getNavigation().moveTo((double)x, (double)y, (double)z, moveSpeedAmp);
            } else {
                int tries;
                int gatherZ;
                int gatherY;
                double d = (double)((float)x + 0.5f) - ent.getX();
                double d2 = (double)((float)z + 0.5f) - ent.getZ();
                double d1 = (double)((float)y + 0.5f) - (ent.getY() + (double)ent.getEyeHeight());
                double d3 = Mth.sqrt((float)((float)(d * d + d2 * d2)));
                float f2 = (float)(Math.atan2(d2, d) * 180.0 / Math.PI) - 90.0f;
                float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
                float rotationPitch = -f3;
                float rotationYaw = f2;
                Mob center = ent;
                RandomSource rand = world.random;
                float randLook = rand.nextInt(90) - 45;
                double dist = followDist * 0.75 + (double)rand.nextInt((int)followDist / 2);
                int gatherX = (int)Math.floor(center.getX() + -Math.sin((rotationYaw + randLook) / 180.0f * (float)Math.PI) * dist);
                BlockPos pos = new BlockPos(gatherX, gatherY = (int)center.getY(), gatherZ = (int)Math.floor(center.getZ() + Math.cos((rotationYaw + randLook) / 180.0f * (float)Math.PI) * dist));
                if (!world.hasChunkAt(pos)) {
                    return false;
                }
                BlockState state = world.getBlockState(pos);
                if (!world.isEmptyBlock(pos)) {
                    for (tries = 0; !(tries >= 30 || world.isEmptyBlock(pos) && world.isEmptyBlock(pos.above())); ++tries) {
                        pos = new BlockPos(gatherX, ++gatherY, gatherZ);
                        state = world.getBlockState(pos);
                    }
                } else {
                    while (tries < 30 && (world.isEmptyBlock(pos) || !state.isSolid() && !world.getFluidState(pos).is(FluidTags.WATER))) {
                        pos = new BlockPos(gatherX, --gatherY, gatherZ);
                        state = world.getBlockState(pos);
                        ++tries;
                    }
                }
                if (tries < 30) {
                    success = ent.getNavigation().moveTo((double)gatherX, (double)gatherY, (double)gatherZ, moveSpeedAmp);
                }
            }
        }
        return success;
    }

    @Nullable
    public static BlockPos findBlock(Mob entity, int scanRange, BiPredicate<Level, BlockPos> predicate) {
        int scanSize = scanRange;
        int scanSizeY = scanRange / 2;
        int adjustRangeY = 10;
        int tryY = Mth.floor((double)entity.getY()) - 1;
        for (int ii = 0; ii <= 10; ++ii) {
            if (ii <= 3) {
                scanSize = 20;
                scanSizeY = 5;
            } else {
                scanSize = scanRange;
                scanSizeY = scanRange / 2;
            }
            int tryX = Mth.floor((double)entity.getX()) + (entity.level().random.nextInt(scanSize) - scanSize / 2);
            int i = tryY + entity.level().random.nextInt(scanSizeY) - scanSizeY / 2;
            int tryZ = Mth.floor((double)entity.getZ()) + entity.level().random.nextInt(scanSize) - scanSize / 2;
            BlockPos posTry = new BlockPos(tryX, tryY, tryZ);
            boolean foundBlock = false;
            int newY = i;
            if (!entity.level().isEmptyBlock(posTry)) {
                tryMax = adjustRangeY;
                while (!entity.level().isEmptyBlock(posTry) && tryMax-- > 0) {
                    posTry = new BlockPos(tryX, ++newY, tryZ);
                }
                if (entity.level().isEmptyBlock(posTry) && predicate.test(entity.level(), posTry.offset(0, -1, 0))) {
                    foundBlock = true;
                }
            } else {
                tryMax = adjustRangeY;
                while (entity.level().isEmptyBlock(posTry) && tryMax-- > 0) {
                    posTry = new BlockPos(tryX, --newY, tryZ);
                }
                if (entity.level().isEmptyBlock(posTry.offset(0, 1, 0)) && predicate.test(entity.level(), posTry)) {
                    foundBlock = true;
                }
            }
            if (!foundBlock) continue;
            return posTry;
        }
        return null;
    }

    public static boolean isDeepWater(Level world, BlockPos pos) {
        boolean clearAbove = world.isEmptyBlock(pos.above(1)) && world.isEmptyBlock(pos.above(2)) && world.isEmptyBlock(pos.above(3));
        boolean deep = world.getFluidState(pos).is(FluidTags.WATER) && world.getFluidState(pos.below()).is(FluidTags.WATER);
        boolean notUnderground = false;
        if (deep) {
            int height = world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).getY() - 1;
            notUnderground = height == pos.getY();
        }
        return deep && notUnderground && clearAbove;
    }

    public static boolean isLand(Level world, BlockPos pos) {
        return world.getBlockState(pos).isSolid();
    }

    public static double getDistance(Entity ent, double x, double y, double z) {
        double d0 = ent.getX() - x;
        double d1 = ent.getY() - y;
        double d2 = ent.getZ() - z;
        return Mth.sqrt((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
    }

    public static Direction.Axis getAxisBetween(BlockPos start, BlockPos end) {
        int zOffset;
        Direction.Axis axis = Direction.Axis.Y;
        int xOffset = Math.abs(end.getX() - start.getX());
        int maxOffset = Math.max(xOffset, zOffset = Math.abs(end.getZ() - start.getZ()));
        if (maxOffset > 0) {
            axis = xOffset == maxOffset ? Direction.Axis.X : Direction.Axis.Z;
        }
        return axis;
    }

    @Nullable
    public static BlockPos findLowestBlock(List<BlockPos> blocks) {
        if (blocks.isEmpty()) {
            return null;
        }
        BlockPos lowest = blocks.getFirst();
        for (int i = 1; i < blocks.size(); ++i) {
            BlockPos block = blocks.get(i);
            if (lowest.getY() <= block.getY()) continue;
            lowest = block;
        }
        return lowest;
    }
}

