/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.tileentity.BambooChestBlockEntity;

public final class BambooChestBlock
extends ChestBlock {
    public static final MapCodec<BambooChestBlock> CODEC = BambooChestBlock.simpleCodec(BambooChestBlock::new);
    public static final DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>> MENU_PROVIDER_COMBINER = new DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>>(){

        public Optional<MenuProvider> acceptDouble(final ChestBlockEntity left, final ChestBlockEntity right) {
            CompoundContainer inventory = new CompoundContainer((Container)left, (Container)right);
            return Optional.of(new MenuProvider(){
                final /* synthetic */ Container val$inventory;
                {
                    this.val$inventory = container;
                }

                @Nullable
                public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
                    if (left.canOpen(player) && right.canOpen(player)) {
                        left.unpackLootTable(playerInventory.player);
                        right.unpackLootTable(playerInventory.player);
                        return ChestMenu.sixRows((int)id, (Inventory)playerInventory, (Container)this.val$inventory);
                    }
                    return null;
                }

                public Component getDisplayName() {
                    if (left.hasCustomName()) {
                        return left.getDisplayName();
                    }
                    return right.hasCustomName() ? right.getDisplayName() : Component.translatable((String)"tropicraft.container.bambooChestDouble");
                }
            });
        }

        public Optional<MenuProvider> acceptSingle(ChestBlockEntity chest) {
            return Optional.of(chest);
        }

        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };

    protected BambooChestBlock(BlockBehaviour.Properties props) {
        super(props, () -> (BlockEntityType)TropicraftBlocks.BAMBOO_CHEST_ENTITY.get());
    }

    public MapCodec<BambooChestBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BambooChestBlockEntity((BlockEntityType<BambooChestBlockEntity>)((BlockEntityType)TropicraftBlocks.BAMBOO_CHEST_ENTITY.get()), pos, state);
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        return ((Optional)this.combine(state, worldIn, pos, false).apply(MENU_PROVIDER_COMBINER)).orElse(null);
    }

    @Deprecated
    public float getDestroyProgress(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        BambooChestBlockEntity tileEntity = (BambooChestBlockEntity)world.getBlockEntity(pos);
        if (tileEntity != null && tileEntity.isUnbreakable()) {
            return 0.0f;
        }
        return super.getDestroyProgress(state, player, world, pos);
    }
}

