/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public final class BoardwalkBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<BoardwalkBlock> CODEC = BoardwalkBlock.simpleCodec(BoardwalkBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final EnumProperty<Type> TYPE = EnumProperty.create((String)"type", Type.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape BOTTOM_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape TOP_SHAPE = Block.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BoardwalkBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue(TYPE, (Comparable)((Object)Type.SHORT))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<BoardwalkBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Type type = (Type)((Object)state.getValue(TYPE));
        if (type.isTall()) {
            return type.hasPost() ? Shapes.block() : TOP_SHAPE;
        }
        return BOTTOM_SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        boolean tall = context.getClickLocation().y - (double)pos.getY() > 0.5;
        BlockState state = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)context.getHorizontalDirection().getAxis())).setValue(TYPE, (Comparable)((Object)(tall ? Type.TALL : Type.SHORT)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).getType() == Fluids.WATER));
        state = this.applyConnections(state, (LevelAccessor)world, pos);
        return state;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (facing != Direction.UP) {
            return this.applyConnections(state, world, currentPos);
        }
        return state;
    }

    private BlockState applyConnections(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        boolean tall = ((Type)((Object)state.getValue(TYPE))).isTall();
        BlockPos downPos = pos.below();
        boolean posted = BoardwalkBlock.canSupportCenter((LevelReader)world, (BlockPos)downPos, (Direction)Direction.UP);
        if (tall) {
            boolean front = this.connectsTo(world, pos, axis, Direction.AxisDirection.POSITIVE);
            boolean back = this.connectsTo(world, pos, axis, Direction.AxisDirection.NEGATIVE);
            if (front || back) {
                posted = true;
            }
            Type type = Type.tall(posted, front, back);
            return (BlockState)state.setValue(TYPE, (Comparable)((Object)type));
        }
        return (BlockState)state.setValue(TYPE, (Comparable)((Object)(posted ? Type.SHORT_POST : Type.SHORT)));
    }

    private boolean connectsTo(LevelAccessor world, BlockPos pos, Direction.Axis axis, Direction.AxisDirection direction) {
        BlockPos connectPos = pos.relative(Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)direction));
        BlockState connectState = world.getBlockState(connectPos);
        return connectState.is((Block)this) && ((Type)((Object)connectState.getValue(TYPE))).isShort();
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case Z: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, TYPE, WATERLOGGED});
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public static enum Type implements StringRepresentable
    {
        TALL("tall"),
        TALL_POST("tall_post"),
        TALL_POST_FRONT("tall_post_front"),
        TALL_POST_BACK("tall_post_back"),
        TALL_POST_FRONT_BACK("tall_post_front_back"),
        SHORT("short"),
        SHORT_POST("short_post");

        public static final Type[] TALLS;
        public static final Type[] SHORTS;
        public static final Type[] TALL_POSTS;
        public static final Type[] SHORT_POSTS;
        public static final Type[] FRONTS;
        public static final Type[] BACKS;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public static Type tall(boolean posted, boolean front, boolean back) {
            if (posted) {
                if (front && back) {
                    return TALL_POST_FRONT_BACK;
                }
                if (front) {
                    return TALL_POST_FRONT;
                }
                if (back) {
                    return TALL_POST_BACK;
                }
                return TALL_POST;
            }
            return TALL;
        }

        public boolean isShort() {
            return this == SHORT || this == SHORT_POST;
        }

        public boolean isTall() {
            return !this.isShort();
        }

        public boolean hasPost() {
            return this == TALL_POST || this == TALL_POST_FRONT || this == TALL_POST_BACK || this == TALL_POST_FRONT_BACK;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            TALLS = new Type[]{TALL, TALL_POST, TALL_POST_FRONT, TALL_POST_BACK, TALL_POST_FRONT_BACK};
            SHORTS = new Type[]{SHORT, SHORT_POST};
            TALL_POSTS = new Type[]{TALL_POST, TALL_POST_FRONT, TALL_POST_BACK, TALL_POST_FRONT_BACK};
            SHORT_POSTS = new Type[]{SHORT_POST};
            FRONTS = new Type[]{TALL_POST_FRONT, TALL_POST_FRONT_BACK};
            BACKS = new Type[]{TALL_POST_BACK, TALL_POST_FRONT_BACK};
        }
    }
}

