/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.tileentity.DrinkMixerBlockEntity;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.TropicraftDrinks;
import net.tropicraft.core.common.item.TropicraftItems;

public final class DrinkMixerBlock
extends BaseEntityBlock {
    public static final MapCodec<DrinkMixerBlock> CODEC = DrinkMixerBlock.simpleCodec(DrinkMixerBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public DrinkMixerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<DrinkMixerBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return DrinkMixerBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TropicraftBlocks.DRINK_MIXER_ENTITY.get()), DrinkMixerBlockEntity::mixTick);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")).withStyle(ChatFormatting.GRAY));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof DrinkMixerBlockEntity)) {
            return InteractionResult.FAIL;
        }
        DrinkMixerBlockEntity mixer = (DrinkMixerBlockEntity)blockEntity;
        if (mixer.isDoneMixing()) {
            mixer.retrieveResult(player);
            return InteractionResult.CONSUME;
        }
        mixer.emptyMixer(player);
        return InteractionResult.CONSUME;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof DrinkMixerBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        DrinkMixerBlockEntity mixer = (DrinkMixerBlockEntity)blockEntity;
        if (mixer.isDoneMixing()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack ingredientStack = stack.copyWithCount(1);
        if (mixer.addToMixer(level, ingredientStack) && !player.isCreative()) {
            player.getInventory().removeItem(player.getInventory().selected, 1);
        }
        if (ingredientStack.is(TropicraftItems.BAMBOO_MUG) && mixer.canMix()) {
            Holder<Drink> craftedDrink;
            mixer.startMixing();
            if (!player.isCreative()) {
                player.getInventory().removeItem(player.getInventory().selected, 1);
            }
            if ((craftedDrink = Drink.getMatchingDrinkByItems((HolderLookup.Provider)level.registryAccess(), mixer.getDrinkIngredients())) == null || craftedDrink.is(TropicraftDrinks.PINA_COLADA)) {
                // empty if block
            }
        }
        return ItemInteractionResult.CONSUME;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState ret = super.getStateForPlacement(context);
        return (BlockState)ret.setValue((Property)FACING, (Comparable)context.getPlayer().getDirection());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DrinkMixerBlockEntity((BlockEntityType<DrinkMixerBlockEntity>)((BlockEntityType)TropicraftBlocks.DRINK_MIXER_ENTITY.get()), pos, state);
    }
}

