/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tropicraft.core.common.block.GrowableDoublePlantBlock;

public final class GrowableSinglePlantBlock
extends BushBlock
implements BonemealableBlock {
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    private final Supplier<BlockEntry<GrowableDoublePlantBlock>> growInto;

    public GrowableSinglePlantBlock(BlockBehaviour.Properties properties, Supplier<BlockEntry<GrowableDoublePlantBlock>> growInto) {
        super(properties);
        this.growInto = growInto;
    }

    protected MapCodec<GrowableSinglePlantBlock> codec() {
        throw new UnsupportedOperationException();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        DoublePlantBlock growBlock = (DoublePlantBlock)this.growInto.get().get();
        BlockState growState = growBlock.defaultBlockState();
        if (growState.canSurvive((LevelReader)world, pos) && world.isEmptyBlock(pos.above())) {
            DoublePlantBlock.placeAt((LevelAccessor)world, (BlockState)growState, (BlockPos)pos, (int)2);
        }
    }
}

