/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.tileentity.SifterBlockEntity;

public class SifterBlock
extends BaseEntityBlock {
    public static final MapCodec<SifterBlock> CODEC = SifterBlock.simpleCodec(SifterBlock::new);

    public SifterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<SifterBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SifterBlockEntity((BlockEntityType<SifterBlockEntity>)((BlockEntityType)TropicraftBlocks.SIFTER_ENTITY.get()), pos, state);
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return SifterBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TropicraftBlocks.SIFTER_ENTITY.get()), SifterBlockEntity::siftTick);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!stack.is(ItemTags.SAND)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof SifterBlockEntity) {
            SifterBlockEntity sifter = (SifterBlockEntity)blockEntity;
            if (!stack.isEmpty() && !sifter.isSifting()) {
                ItemStack addItem = stack.consumeAndReturn(1, (LivingEntity)player);
                sifter.addItemToSifter(addItem);
                sifter.startSifting();
                return ItemInteractionResult.CONSUME;
            }
        }
        return ItemInteractionResult.SUCCESS;
    }
}

