/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class TropicraftLeavesBlock
extends LeavesBlock {
    public static final MapCodec<TropicraftLeavesBlock> CODEC = TropicraftLeavesBlock.simpleCodec(TropicraftLeavesBlock::new);
    public static final List<BlockPos> AROUND_OFFSETS = BlockPos.betweenClosedStream((int)-1, (int)-1, (int)-1, (int)1, (int)1, (int)1).map(BlockPos::immutable).filter(pos -> !pos.equals((Object)BlockPos.ZERO)).toList();
    public static final List<BlockPos> INDIRECT_NEIGHBOR_OFFSETS = AROUND_OFFSETS.stream().filter(pos -> pos.distManhattan((Vec3i)BlockPos.ZERO) > 1).toList();

    public TropicraftLeavesBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public MapCodec<TropicraftLeavesBlock> codec() {
        return CODEC;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return false;
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.setBlock(pos, TropicraftLeavesBlock.updateDistance(state, (LevelAccessor)level, pos), 3);
    }

    protected void updateIndirectNeighbourShapes(BlockState state, LevelAccessor level, BlockPos pos, int flags, int recursionLeft) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Vec3i vec3i : INDIRECT_NEIGHBOR_OFFSETS) {
            mutablePos.setWithOffset((Vec3i)pos, vec3i);
            if (!level.getBlockState((BlockPos)mutablePos).is((Block)this)) continue;
            level.neighborShapeChanged(Direction.DOWN, state, (BlockPos)mutablePos, pos, flags, recursionLeft);
        }
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        int newDistance;
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if ((newDistance = TropicraftLeavesBlock.getDistanceAt(facingState) + 1) != 1 || (Integer)state.getValue((Property)DISTANCE) != newDistance) {
            level.scheduleTick(currentPos, (Block)this, 1);
        }
        return state;
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor level, BlockPos pos) {
        int minDistance = 7;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Vec3i vec3i : AROUND_OFFSETS) {
            mutablePos.setWithOffset((Vec3i)pos, vec3i);
            if ((minDistance = Math.min(minDistance, TropicraftLeavesBlock.getDistanceAt(level.getBlockState((BlockPos)mutablePos)) + 1)) != 1) continue;
            break;
        }
        return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(minDistance));
    }

    private static int getDistanceAt(BlockState neighbor) {
        return TropicraftLeavesBlock.getOptionalDistanceAt((BlockState)neighbor).orElse(7);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        return TropicraftLeavesBlock.updateDistance(blockState, (LevelAccessor)context.getLevel(), context.getClickedPos());
    }
}

