/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.huge_plant;

import com.mojang.serialization.MapCodec;
import com.tterrag.registrate.util.entry.RegistryEntry;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.tropicraft.core.client.ParticleEffects;

public final class HugePlantBlock
extends BushBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.create((String)"type", Type.class);
    @Nullable
    private Supplier<RegistryEntry<? extends ItemLike, ? extends ItemLike>> pickItem;

    public HugePlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(TYPE, (Comparable)((Object)Type.SEED)));
    }

    protected MapCodec<? extends BushBlock> codec() {
        throw new UnsupportedOperationException();
    }

    public HugePlantBlock setPickItem(Supplier<RegistryEntry<? extends ItemLike, ? extends ItemLike>> item) {
        this.pickItem = item;
        return this;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        for (BlockPos plantPos : Shape.fromSeed((Block)this, pos)) {
            if (plantPos.equals((Object)pos) || world.getBlockState(plantPos).canBeReplaced(context)) continue;
            return null;
        }
        return (BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)((Object)Type.SEED));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Shape shape = Shape.fromSeed((Block)this, pos);
        for (BlockPos plantPos : shape) {
            if (plantPos.equals((Object)pos)) continue;
            BlockState plantState = shape.blockAt(plantPos);
            world.setBlock(plantPos, plantState, 3);
        }
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        Shape shape = Shape.match((Block)this, (BlockGetter)world, pos);
        if (shape == null) {
            return Blocks.AIR.defaultBlockState();
        }
        if (this.isValidPosition(world, shape)) {
            return state;
        }
        return Blocks.AIR.defaultBlockState();
    }

    private boolean isValidPosition(LevelAccessor world, Shape shape) {
        BlockPos seedPos = shape.seed();
        BlockState seedState = world.getBlockState(seedPos);
        return super.canSurvive(seedState, (LevelReader)world, seedPos);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (HugePlantBlock.isSeedBlock((Block)this, state)) {
            BlockState worldState = world.getBlockState(pos);
            if (worldState != state && !this.isValidPositionToPlace(world, pos)) {
                return false;
            }
            return super.canSurvive(state, world, pos);
        }
        return Shape.match((Block)this, (BlockGetter)world, pos) != null;
    }

    private boolean isValidPositionToPlace(LevelReader world, BlockPos pos) {
        for (BlockPos plantPos : Shape.fromSeed((Block)this, pos)) {
            if (world.getBlockState(plantPos).canBeReplaced()) continue;
            return false;
        }
        return true;
    }

    public void placeAt(LevelAccessor world, BlockPos pos, int flags) {
        Shape shape = Shape.fromSeed((Block)this, pos);
        for (BlockPos plantPos : shape) {
            BlockState plantState = shape.blockAt(plantPos);
            world.setBlock(plantPos, plantState, flags);
        }
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        Shape shape = Shape.match((Block)this, (BlockGetter)world, pos);
        if (shape == null) {
            return state;
        }
        if (!world.isClientSide) {
            if (!player.isCreative()) {
                HugePlantBlock.dropResources((BlockState)state, (Level)world, (BlockPos)shape.seed(), null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
            int flags = 50;
            SoundType soundtype = state.getSoundType((LevelReader)world, pos, null);
            world.playSound(null, pos, soundtype.getBreakSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
            for (BlockPos plantPos : shape) {
                world.setBlock(plantPos, Blocks.AIR.defaultBlockState(), flags);
            }
        } else {
            for (BlockPos plantPos : shape) {
                ParticleEffects.breakBlockWithFewerParticles(world, state, plantPos);
            }
        }
        return state;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        if (state.getValue(TYPE) == Type.SEED) {
            return super.getDrops(state, params);
        }
        return Collections.emptyList();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (this.pickItem != null) {
            return new ItemStack((ItemLike)this.pickItem.get().get());
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE});
    }

    private static boolean isSeedBlock(Block block, BlockState state) {
        return state.is(block) && state.getValue(TYPE) == Type.SEED;
    }

    public static enum Type implements StringRepresentable
    {
        SEED("seed"),
        CENTER("center"),
        OUTER("outer");

        private final String key;

        private Type(String key) {
            this.key = key;
        }

        public String getSerializedName() {
            return this.key;
        }
    }

    public static final class Shape
    implements Iterable<BlockPos> {
        public static final int RADIUS = 1;
        private final Block block;
        private final BlockPos seed;

        private Shape(Block block, BlockPos seed) {
            this.block = block;
            this.seed = seed;
        }

        public static Shape fromSeed(Block block, BlockPos seed) {
            return new Shape(block, seed);
        }

        @Nullable
        public static Shape match(Block block, BlockGetter world, BlockPos pos) {
            for (BlockPos plantPos : Shape.matchPositions(pos)) {
                Shape shape;
                if (!HugePlantBlock.isSeedBlock(block, world.getBlockState(plantPos)) || !(shape = Shape.fromSeed(block, plantPos)).validate(world)) continue;
                return shape;
            }
            return null;
        }

        @Nullable
        public static Shape matchIncomplete(Block block, BlockGetter world, BlockPos pos) {
            for (BlockPos plantPos : Shape.matchPositions(pos)) {
                if (!HugePlantBlock.isSeedBlock(block, world.getBlockState(plantPos))) continue;
                return Shape.fromSeed(block, plantPos);
            }
            return null;
        }

        private static Iterable<BlockPos> matchPositions(BlockPos pos) {
            BlockPos minPos = pos.offset(-1, -2, -1);
            BlockPos maxPos = pos.offset(1, 0, 1);
            return BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos);
        }

        public boolean validate(BlockGetter world) {
            for (BlockPos pos : this) {
                if (world.getBlockState(pos).is(this.block)) continue;
                return false;
            }
            return true;
        }

        public BlockState blockAt(BlockPos pos) {
            Type type = Type.OUTER;
            if (pos.equals((Object)this.seed())) {
                type = Type.SEED;
            } else if (pos.equals((Object)this.center())) {
                type = Type.CENTER;
            }
            return (BlockState)this.block.defaultBlockState().setValue(TYPE, (Comparable)((Object)type));
        }

        public BlockPos seed() {
            return this.seed;
        }

        public BlockPos center() {
            return this.seed.offset(0, 1, 0);
        }

        public AABB asAabb() {
            BlockPos seed = this.seed;
            return new AABB((double)(seed.getX() - 1), (double)seed.getY(), (double)(seed.getZ() - 1), (double)(seed.getX() + 1) + 1.0, (double)(seed.getY() + 2) + 1.0, (double)(seed.getZ() + 1) + 1.0);
        }

        @Override
        public Iterator<BlockPos> iterator() {
            BlockPos center = this.center();
            return BlockPos.betweenClosed((BlockPos)center.offset(-1, -1, -1), (BlockPos)center.offset(1, 1, 1)).iterator();
        }
    }
}

