/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import net.tropicraft.core.common.block.DrinkMixerBlock;
import net.tropicraft.core.common.block.tileentity.IMachineBlock;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.DrinkIngredient;
import net.tropicraft.core.common.network.message.ClientboundMixerInventoryPacket;
import net.tropicraft.core.common.network.message.ClientboundMixerStartPacket;
import org.slf4j.Logger;

public class DrinkMixerBlockEntity
extends BlockEntity
implements IMachineBlock {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TICKS_TO_MIX = 80;
    private int ticks;
    private final List<ItemStack> drinkIngredients;
    private boolean mixing = false;
    public ItemStack result = ItemStack.EMPTY;

    public DrinkMixerBlockEntity(BlockEntityType<DrinkMixerBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.drinkIngredients = new ArrayList<ItemStack>();
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.ticks = nbt.getInt("MixTicks");
        this.mixing = nbt.getBoolean("Mixing");
        ItemStack.SINGLE_ITEM_CODEC.listOf().parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt.get("ingredients")).resultOrPartial(error -> LOGGER.error("Failed to parse drink mixer ingredients: '{}'", error)).ifPresent(this::setDrinkIngredients);
        this.result = nbt.contains("Result") ? ItemStack.parse((HolderLookup.Provider)registries, (Tag)nbt.getCompound("Result")).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putInt("MixTicks", this.ticks);
        nbt.putBoolean("Mixing", this.mixing);
        RegistryOps registryOps = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        nbt.put("ingredients", (Tag)ItemStack.SINGLE_ITEM_CODEC.listOf().encodeStart((DynamicOps)registryOps, this.drinkIngredients).getOrThrow());
        if (!this.result.isEmpty()) {
            nbt.put("Result", this.result.save(registries, (Tag)new CompoundTag()));
        }
    }

    public static void mixTick(Level level, BlockPos pos, BlockState state, DrinkMixerBlockEntity mixer) {
        mixer.tick();
    }

    private void tick() {
        if (this.ticks < 80 && this.mixing) {
            ++this.ticks;
            if (this.ticks == 80) {
                this.finishMixing();
            }
        }
    }

    public boolean isDoneMixing() {
        return !this.result.isEmpty();
    }

    public List<ItemStack> getDrinkIngredients() {
        return this.drinkIngredients;
    }

    public void setDrinkIngredients(List<ItemStack> ingredients) {
        this.drinkIngredients.clear();
        this.drinkIngredients.addAll(ingredients);
    }

    public void startMixing() {
        this.ticks = 0;
        this.mixing = true;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new ClientboundMixerStartPacket(this.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void dropItem(ItemStack stack, @Nullable Player at) {
        if (at == null) {
            BlockPos pos = this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)DrinkMixerBlock.FACING));
            Containers.dropItemStack((Level)this.level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
        } else {
            Containers.dropItemStack((Level)this.level, (double)at.getX(), (double)at.getY(), (double)at.getZ(), (ItemStack)stack);
        }
    }

    public void emptyMixer(@Nullable Player at) {
        for (ItemStack stack : this.drinkIngredients) {
            this.dropItem(stack, at);
        }
        this.drinkIngredients.clear();
        this.ticks = 80;
        this.mixing = false;
        this.syncInventory();
    }

    public void retrieveResult(@Nullable Player at) {
        if (this.result.isEmpty()) {
            return;
        }
        this.dropItem(this.result, at);
        for (ItemStack ingredient : this.drinkIngredients) {
            ItemStack container = ingredient.getCraftingRemainingItem();
            if (container.isEmpty()) continue;
            this.dropItem(container, at);
        }
        this.drinkIngredients.clear();
        this.result = ItemStack.EMPTY;
        this.syncInventory();
    }

    public void finishMixing() {
        this.result = this.getResult();
        this.mixing = false;
        this.ticks = 0;
        this.syncInventory();
    }

    public boolean addToMixer(Level level, ItemStack itemStack) {
        if (this.isMixerFull()) {
            return false;
        }
        if (DrinkIngredient.findMatchingIngredient((HolderLookup.Provider)level.registryAccess(), itemStack) != null) {
            this.drinkIngredients.add(itemStack);
            this.syncInventory();
            return true;
        }
        return false;
    }

    public boolean isMixing() {
        return this.mixing;
    }

    private boolean isMixerFull() {
        return this.drinkIngredients.size() >= 3;
    }

    public boolean canMix() {
        return !this.mixing && this.isMixerFull();
    }

    @Override
    public boolean isActive() {
        return this.isMixing();
    }

    @Override
    public float getProgress(float partialTicks) {
        return ((float)this.ticks + partialTicks) / 80.0f;
    }

    @Override
    public Direction getDirection(BlockState state) {
        return (Direction)state.getValue((Property)DrinkMixerBlock.FACING);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        this.loadAdditional(pkt.getTag(), registries);
    }

    protected void syncInventory() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new ClientboundMixerInventoryPacket(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.setChanged();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.writeItems(new CompoundTag(), registries);
    }

    private CompoundTag writeItems(CompoundTag nbt, HolderLookup.Provider registries) {
        this.saveAdditional(nbt, registries);
        return nbt;
    }

    public ItemStack getResult() {
        return Drink.getResult((HolderLookup.Provider)this.level.registryAccess(), this.drinkIngredients);
    }
}

