/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension;

import com.google.common.collect.ImmutableList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.tropicraft.core.common.block.BlockTropicraftSand;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomes;

public final class TropicraftSurfaces {
    private static final SurfaceRules.RuleSource BEDROCK = TropicraftSurfaces.makeStateRule(Blocks.BEDROCK);
    private static final SurfaceRules.RuleSource DEEPSLATE = TropicraftSurfaces.makeStateRule(Blocks.DEEPSLATE);
    private static final SurfaceRules.RuleSource DIRT = TropicraftSurfaces.makeStateRule(Blocks.DIRT);
    private static final SurfaceRules.RuleSource GRASS_BLOCK = TropicraftSurfaces.makeStateRule(Blocks.GRASS_BLOCK);
    private static final SurfaceRules.RuleSource WATER = TropicraftSurfaces.makeStateRule(Blocks.WATER);
    private static final SurfaceRules.RuleSource STONE = TropicraftSurfaces.makeStateRule(Blocks.STONE);
    private static final SurfaceRules.RuleSource PURIFIED_SAND = TropicraftSurfaces.makeStateRule((Block)TropicraftBlocks.PURIFIED_SAND.get());
    private static final SurfaceRules.RuleSource UNDERWATER_PURIFIED_SAND = TropicraftSurfaces.makeStateRule((BlockState)((BlockTropicraftSand)((Object)TropicraftBlocks.PURIFIED_SAND.get())).defaultBlockState().setValue((Property)BlockTropicraftSand.UNDERWATER, (Comparable)Boolean.valueOf(true)));
    private static final SurfaceRules.RuleSource SANDSTONE = TropicraftSurfaces.makeStateRule(Blocks.SANDSTONE);
    private static final SurfaceRules.RuleSource MUD = TropicraftSurfaces.makeStateRule((Block)TropicraftBlocks.MUD.get());

    private static SurfaceRules.RuleSource makeStateRule(Block block) {
        return SurfaceRules.state((BlockState)block.defaultBlockState());
    }

    private static SurfaceRules.RuleSource makeStateRule(BlockState state) {
        return SurfaceRules.state((BlockState)state);
    }

    public static SurfaceRules.RuleSource tropics() {
        SurfaceRules.ConditionSource atOrAboveSeaLevel = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)126), (int)0);
        SurfaceRules.ConditionSource aboveSeaLevel = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)127), (int)0);
        SurfaceRules.ConditionSource notUnderWater = SurfaceRules.waterBlockCheck((int)-1, (int)0);
        SurfaceRules.ConditionSource underWater = SurfaceRules.not((SurfaceRules.ConditionSource)notUnderWater);
        SurfaceRules.ConditionSource isMangrovey = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{TropicraftBiomes.MANGROVES, TropicraftBiomes.OVERGROWN_MANGROVES});
        SurfaceRules.ConditionSource notUnderDeepWater = SurfaceRules.waterStartCheck((int)-6, (int)-1);
        SurfaceRules.RuleSource grassRule = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)notUnderWater, (SurfaceRules.RuleSource)GRASS_BLOCK), DIRT});
        SurfaceRules.RuleSource sandRule = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_CEILING, (SurfaceRules.RuleSource)SANDSTONE), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)underWater, (SurfaceRules.RuleSource)UNDERWATER_PURIFIED_SAND), PURIFIED_SAND})});
        SurfaceRules.ConditionSource isSandy = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{TropicraftBiomes.OCEAN, TropicraftBiomes.KELP_FOREST, TropicraftBiomes.RIVER, TropicraftBiomes.BEACH});
        SurfaceRules.ConditionSource isStony = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{TropicraftBiomes.TROPICAL_PEAKS});
        SurfaceRules.RuleSource surfaceRule = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isMangrovey, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.CALCITE, (double)-0.0125, (double)0.0125), (SurfaceRules.RuleSource)MUD)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isMangrovey, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)TropicraftSurfaces.surfaceNoiseAbove(2.25), (SurfaceRules.RuleSource)MUD)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{TropicraftBiomes.TROPICS}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)TropicraftSurfaces.surfaceNoiseAbove(1.35), (SurfaceRules.RuleSource)sandRule)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSandy, (SurfaceRules.RuleSource)sandRule), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isStony, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.steep(), (SurfaceRules.RuleSource)STONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.CALCITE, (double)-0.0125, (double)0.0125), (SurfaceRules.RuleSource)STONE)}))});
        SurfaceRules.RuleSource underFloorRule = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{surfaceRule, DIRT});
        SurfaceRules.RuleSource floorRule = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{surfaceRule, grassRule});
        SurfaceRules.RuleSource aboveSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isMangrovey, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)atOrAboveSeaLevel, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)aboveSeaLevel), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)WATER)))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)notUnderWater, (SurfaceRules.RuleSource)floorRule)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)notUnderDeepWater, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)underFloorRule)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)sandRule)});
        ImmutableList.Builder rules = ImmutableList.builder();
        rules.add((Object)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)5)), (SurfaceRules.RuleSource)BEDROCK));
        rules.add((Object)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)aboveSurface));
        rules.add((Object)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"deepslate", (VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)8)), (SurfaceRules.RuleSource)DEEPSLATE));
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])rules.build().toArray(SurfaceRules.RuleSource[]::new)));
    }

    private static SurfaceRules.ConditionSource surfaceNoiseAbove(double threshold) {
        return SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)(threshold / 8.25), (double)Double.MAX_VALUE);
    }
}

