/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.tropicraft.core.common.dimension.feature.TropicraftStructureTypes;

public class HomeTreeStructure
extends Structure {
    public static final MapCodec<HomeTreeStructure> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)HomeTreeStructure.settingsCodec((RecordCodecBuilder.Instance)i), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(s -> s.startPool), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(s -> s.maxDepth)).apply((Applicative)i, HomeTreeStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final int maxDepth;

    public HomeTreeStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int maxDepth) {
        super(settings);
        this.startPool = startPool;
        this.maxDepth = maxDepth;
    }

    private static boolean isValid(ChunkGenerator generator, BlockPos pos, int startY, LevelHeightAccessor level, RandomState randomState) {
        int y = generator.getBaseHeight(pos.getX(), pos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, level, randomState);
        return y >= generator.getSeaLevel() && Math.abs(y - startY) < 10 && y < 150 && y > generator.getSeaLevel() + 2;
    }

    private static boolean checkLocation(Structure.GenerationContext context, BlockPos pos) {
        ChunkGenerator generator = context.chunkGenerator();
        RandomState randomState = context.randomState();
        LevelHeightAccessor level = context.heightAccessor();
        int y = generator.getBaseHeight(pos.getX(), pos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, level, randomState);
        return HomeTreeStructure.isValid(generator, pos.offset(-4, 0, -4), y, level, randomState) && HomeTreeStructure.isValid(generator, pos.offset(-4, 0, 4), y, level, randomState) && HomeTreeStructure.isValid(generator, pos.offset(4, 0, 4), y, level, randomState) && HomeTreeStructure.isValid(generator, pos.offset(4, 0, -4), y, level, randomState);
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        BlockPos startPos = new BlockPos(chunkPos.getMinBlockX(), 0, chunkPos.getMinBlockZ());
        if (!HomeTreeStructure.checkLocation(context, startPos)) {
            return Optional.empty();
        }
        return JigsawPlacement.addPieces((Structure.GenerationContext)context, this.startPool, Optional.empty(), (int)this.maxDepth, (BlockPos)startPos, (boolean)false, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), (int)80, (PoolAliasLookup)PoolAliasLookup.EMPTY, (DimensionPadding)DimensionPadding.ZERO, (LiquidSettings)LiquidSettings.APPLY_WATERLOGGING);
    }

    public StructureType<?> type() {
        return (StructureType)TropicraftStructureTypes.HOME_TREE.get();
    }
}

