/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.tropicraft.core.common.dimension.feature.SimpleTreeFeatureConfig;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;

public class SingleUndergrowthFeature
extends Feature<SimpleTreeFeatureConfig> {
    private static final int LARGE_BUSH_CHANCE = 4;

    public SingleUndergrowthFeature(Codec<SimpleTreeFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<SimpleTreeFeatureConfig> context) {
        int size;
        WorldGenLevel level = context.level();
        context.chunkGenerator();
        RandomSource rand = context.random();
        BlockPos pos = context.origin();
        SimpleTreeFeatureConfig config = (SimpleTreeFeatureConfig)context.config();
        int n = size = rand.nextInt(4) == 0 ? 3 : 2;
        if (!this.isValidPosition((LevelSimulatedReader)level, pos)) {
            return false;
        }
        if (TropicraftFeatureUtil.goesBeyondWorldSize(level, pos.getY(), size)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isSoil((LevelAccessor)level, pos.below())) {
            return false;
        }
        level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 3);
        int count = 0;
        if (this.isValidPosition((LevelSimulatedReader)level, pos) && pos.getY() < level.getMaxBuildHeight() - 1) {
            for (int y = pos.getY(); y < pos.getY() + size; ++y) {
                int bushWidth = size - (y - pos.getY());
                for (int x = pos.getX() - bushWidth; x < pos.getX() + bushWidth; ++x) {
                    int xVariance = x - pos.getX();
                    for (int z = pos.getZ() - bushWidth; z < pos.getZ() + bushWidth; ++z) {
                        int zVariance = z - pos.getZ();
                        BlockPos newPos = new BlockPos(x, y, z);
                        if (Math.abs(xVariance) == bushWidth && Math.abs(zVariance) == bushWidth && rand.nextInt(2) == 0 || !this.isValidPosition((LevelSimulatedReader)level, newPos)) continue;
                        this.setBlock((LevelWriter)level, newPos, config.leaves().get());
                    }
                }
            }
            ++count;
        }
        this.setBlock((LevelWriter)level, pos, config.log().get());
        return count > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isValidPosition(LevelSimulatedReader level, BlockPos pos) {
        if (!TreeFeature.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)pos)) return false;
        if (level.isStateAtPosition(pos, Blocks.CAVE_AIR.defaultBlockState()::equals)) return false;
        return true;
    }
}

