/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;

public class UndergrowthFeature
extends Feature<NoneFeatureConfiguration> {
    private static final int LARGE_BUSH_CHANCE = 5;

    public UndergrowthFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        RandomSource rand = context.random();
        BlockPos pos = context.origin();
        int size = 2;
        if (rand.nextInt(5) == 0) {
            size = 3;
        }
        if (!this.isValidPosition((LevelSimulatedRW)world, pos)) {
            return false;
        }
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.getY(), size)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isSoil((LevelAccessor)world, pos.below())) {
            return false;
        }
        world.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 3);
        this.setBlock((LevelWriter)world, pos, ((RotatedPillarBlock)TropicraftBlocks.MAHOGANY_LOG.get()).defaultBlockState());
        int count = 0;
        for (int round = 0; round < 64; ++round) {
            BlockPos posTemp = pos.offset(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!this.isValidPosition((LevelSimulatedRW)world, posTemp) || posTemp.getY() >= 255) continue;
            for (int y = posTemp.getY(); y < posTemp.getY() + size; ++y) {
                int bushWidth = size - (y - posTemp.getY());
                for (int x = posTemp.getX() - bushWidth; x < posTemp.getX() + bushWidth; ++x) {
                    int xVariance = x - posTemp.getX();
                    for (int z = posTemp.getZ() - bushWidth; z < posTemp.getZ() + bushWidth; ++z) {
                        int zVariance = z - posTemp.getZ();
                        BlockPos newPos = new BlockPos(x, y, z);
                        if (Math.abs(xVariance) == bushWidth && Math.abs(zVariance) == bushWidth && rand.nextInt(2) == 0 || !this.isValidPosition((LevelSimulatedRW)world, newPos)) continue;
                        this.setBlock((LevelWriter)world, newPos, ((LeavesBlock)TropicraftBlocks.KAPOK_LEAVES.get()).defaultBlockState());
                    }
                }
            }
            ++count;
        }
        return count > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isValidPosition(LevelSimulatedRW world, BlockPos pos) {
        if (!TreeFeature.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)pos)) return false;
        if (world.isStateAtPosition(pos, Blocks.CAVE_AIR.defaultBlockState()::equals)) return false;
        return true;
    }
}

