/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.tropicraft.core.common.dimension.feature.jigsaw.CheatyStructureProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.TropicraftProcessorTypes;

public class AdjustBuildingHeightProcessor
extends CheatyStructureProcessor {
    public static final MapCodec<AdjustBuildingHeightProcessor> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.INT.optionalFieldOf("base", (Object)126).forGetter(c -> c.base)).apply((Applicative)i, AdjustBuildingHeightProcessor::new));
    private final int base;

    public AdjustBuildingHeightProcessor(int base) {
        this.base = base;
    }

    public StructureTemplate.StructureBlockInfo process(LevelReader worldReaderIn, BlockPos seedPos, BlockPos p, StructureTemplate.StructureBlockInfo p_215194_3_, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings placementSettingsIn, @Nullable StructureTemplate template) {
        if (seedPos.getY() < this.base) {
            return new StructureTemplate.StructureBlockInfo(blockInfo.pos().above(), blockInfo.state(), blockInfo.nbt());
        }
        return blockInfo;
    }

    public StructureTemplate.StructureEntityInfo processEntity(LevelReader world, BlockPos seedPos, StructureTemplate.StructureEntityInfo rawEntityInfo, StructureTemplate.StructureEntityInfo entityInfo, StructurePlaceSettings placementSettings, StructureTemplate template) {
        if (seedPos.getY() < this.base) {
            return new StructureTemplate.StructureEntityInfo(entityInfo.pos.add(0.0, 1.0, 0.0), entityInfo.blockPos.above(), entityInfo.nbt);
        }
        return entityInfo;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)TropicraftProcessorTypes.ADJUST_BUILDING_HEIGHT.get();
    }
}

