/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.dimension.feature.jigsaw.CheatyStructureProcessor;

public abstract class PathStructureProcessor
extends CheatyStructureProcessor {
    private static final WeakHashMap<StructurePlaceSettings, List<PathVector>> VECTOR_CACHE = new WeakHashMap();

    protected PathStructureProcessor() {
    }

    @Nullable
    protected Direction.Axis getPathDirection(LevelReader level, BlockPos seedPos, StructureTemplate.StructureBlockInfo current, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
        StructurePlaceSettings infiniteBounds = settings.copy();
        infiniteBounds.setBoundingBox(BoundingBox.infinite());
        return VECTOR_CACHE.computeIfAbsent(settings, s -> template.filterBlocks(seedPos, infiniteBounds, Blocks.JIGSAW, true).stream().filter(b -> b.nbt().getString("target").equals("tropicraft:path_center")).map(bi -> new PathVector(level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, bi.pos()).subtract((Vec3i)seedPos), JigsawBlock.getFrontFacing((BlockState)bi.state()))).collect(Collectors.toList())).stream().filter(pv -> pv.contains(current.pos().subtract((Vec3i)seedPos), settings)).findFirst().map(pv -> pv.dir.getAxis()).orElse(null);
    }

    private static class PathVector {
        final Direction dir;
        final BoundingBox bb;

        PathVector(BlockPos start, Direction dir) {
            Preconditions.checkArgument((boolean)dir.getAxis().isHorizontal(), (Object)("Invalid direction for path vector at " + String.valueOf(start)));
            this.dir = dir;
            Vec3 ortho = Vec3.atLowerCornerOf((Vec3i)dir.getClockWise().getNormal());
            this.bb = this.toMutable(new AABB(start).expandTowards(Vec3.atLowerCornerOf((Vec3i)dir.getNormal()).scale(16.0)).expandTowards(ortho).expandTowards(ortho.reverse()).inflate(0.0, 3.0, 0.0));
        }

        boolean contains(BlockPos pos, StructurePlaceSettings settings) {
            return this.bb.isInside((Vec3i)StructureTemplate.calculateRelativePosition((StructurePlaceSettings)settings, (BlockPos)pos));
        }

        private BoundingBox toMutable(AABB bb) {
            return new BoundingBox((int)bb.minX, (int)bb.minY, (int)bb.minZ, (int)bb.maxX, (int)bb.maxY, (int)bb.maxZ);
        }
    }
}

