/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.jigsaw.CheatyStructureProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.TropicraftProcessorTypes;

public class SinkInGroundProcessor
extends CheatyStructureProcessor {
    public static final MapCodec<SinkInGroundProcessor> CODEC = MapCodec.unit((Object)((Object)new SinkInGroundProcessor()));

    public StructureTemplate.StructureBlockInfo process(LevelReader world, BlockPos worldPos, BlockPos sourcePos, StructureTemplate.StructureBlockInfo sourceInfo, StructureTemplate.StructureBlockInfo worldInfo, StructurePlaceSettings placement, @Nullable StructureTemplate template) {
        worldPos = worldInfo.pos();
        if (sourceInfo.pos().getY() == 0) {
            if (!this.isAirOrWater(world, worldPos)) {
                return null;
            }
            return worldInfo;
        }
        BlockPos groundCheck = world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, worldPos);
        if (sourceInfo.pos().getY() == 2 && sourceInfo.state().is(TropicraftBlocks.BAMBOO_FENCE)) {
            if (groundCheck.getY() > 127 || !this.isAirOrWater(world, worldPos.below(2))) {
                return null;
            }
            for (int i = 0; i < 4; ++i) {
                if (world.isEmptyBlock(worldPos.relative(Direction.from2DDataValue((int)i)))) continue;
                return null;
            }
        }
        if (groundCheck.getY() > 127) {
            if (!this.isAirOrWater(world, worldPos.below()) && sourceInfo.state().is(TropicraftBlocks.THATCH_SLAB)) {
                worldInfo = new StructureTemplate.StructureBlockInfo(worldPos, ((RotatedPillarBlock)TropicraftBlocks.THATCH_BUNDLE.get()).defaultBlockState(), null);
            }
            if (Block.isShapeFullBlock((VoxelShape)worldInfo.state().getShape((BlockGetter)world, worldPos.below())) || this.isAirOrWater(world, worldPos.below())) {
                return new StructureTemplate.StructureBlockInfo(worldPos.below(), worldInfo.state(), worldInfo.nbt());
            }
        }
        return worldInfo;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)TropicraftProcessorTypes.SINK_IN_GROUND.get();
    }
}

