/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.tropicraft.core.common.dimension.feature.jigsaw.CheatyStructureProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.TropicraftProcessorTypes;

public class StructureSupportsProcessor
extends CheatyStructureProcessor {
    public static final MapCodec<StructureSupportsProcessor> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.optionalFieldOf("can_replace_land", (Object)false).forGetter(p -> p.canReplaceLand), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).fieldOf("blocks_to_extend").forGetter(p -> p.blocksToExtend)).apply((Applicative)i, StructureSupportsProcessor::new));
    private final boolean canReplaceLand;
    private final HolderSet<Block> blocksToExtend;

    public StructureSupportsProcessor(boolean canReplaceLand, HolderSet<Block> blocksToExtend) {
        this.canReplaceLand = canReplaceLand;
        this.blocksToExtend = blocksToExtend;
    }

    public StructureTemplate.StructureBlockInfo process(LevelReader world, BlockPos seedPos, BlockPos pos2, StructureTemplate.StructureBlockInfo originalInfo, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings placement, @Nullable StructureTemplate template) {
        BlockPos pos = blockInfo.pos();
        if (originalInfo.pos().getY() <= 1 && blockInfo.state().is(this.blocksToExtend)) {
            if (!this.canReplaceLand && !this.canPassThrough(world, pos)) {
                return null;
            }
            if (originalInfo.pos().getY() == 0) {
                if (!this.canReplaceLand && !this.canPassThrough(world, pos.above())) {
                    return null;
                }
                BlockPos fencePos = pos.below();
                while (this.canPassThrough(world, fencePos)) {
                    BlockState state = blockInfo.state();
                    if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                        state = (BlockState)state.setValue((Property)FenceBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.getBlockState(fencePos).is(Blocks.WATER)));
                    }
                    this.setBlockState(world, fencePos, state);
                    fencePos = fencePos.below();
                }
            }
        }
        return blockInfo;
    }

    protected boolean canPassThrough(LevelReader world, BlockPos pos) {
        return this.isAirOrWater(world, pos) || world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, pos).getY() < pos.getY();
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)TropicraftProcessorTypes.STRUCTURE_SUPPORTS.get();
    }
}

