/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw.piece;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.TropicraftStructurePoolElementTypes;

public class SingleNoAirJigsawPiece
extends SinglePoolElement {
    public static final MapCodec<SingleNoAirJigsawPiece> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)SingleNoAirJigsawPiece.templateCodec(), (App)SingleNoAirJigsawPiece.processorsCodec(), (App)SingleNoAirJigsawPiece.projectionCodec(), (App)SingleNoAirJigsawPiece.overrideLiquidSettingsCodec(), (App)Codec.BOOL.optionalFieldOf("unprojected", (Object)false).forGetter(p -> p.unprojected)).apply((Applicative)i, SingleNoAirJigsawPiece::new));
    private static final Holder<StructureProcessorList> EMPTY_PROCESSOR_LIST = Holder.direct((Object)new StructureProcessorList(List.of()));
    private final boolean unprojected;

    public SingleNoAirJigsawPiece(Either<ResourceLocation, StructureTemplate> template, Holder<StructureProcessorList> processors, StructureTemplatePool.Projection placementBehaviour, Optional<LiquidSettings> overrideLiquidSettings, boolean unproject) {
        super(template, processors, placementBehaviour, overrideLiquidSettings);
        this.unprojected = unproject;
    }

    public static Function<StructureTemplatePool.Projection, SingleNoAirJigsawPiece> create(ResourceLocation id, Holder<StructureProcessorList> processors, boolean unprojected) {
        return placementBehaviour -> new SingleNoAirJigsawPiece((Either<ResourceLocation, StructureTemplate>)Either.left((Object)id), processors, (StructureTemplatePool.Projection)placementBehaviour, Optional.empty(), unprojected);
    }

    public static Function<StructureTemplatePool.Projection, SingleNoAirJigsawPiece> create(ResourceLocation id) {
        return SingleNoAirJigsawPiece.create(id, EMPTY_PROCESSOR_LIST, false);
    }

    public StructurePoolElementType<?> getType() {
        return (StructurePoolElementType)TropicraftStructurePoolElementTypes.SINGLE_NO_AIR.get();
    }

    protected StructurePlaceSettings getSettings(Rotation rotation, BoundingBox box, LiquidSettings liquidSettings, boolean offset) {
        StructurePlaceSettings settings = super.getSettings(rotation, box, liquidSettings, offset);
        settings.popProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK);
        settings.addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_AND_AIR);
        if (this.unprojected) {
            for (StructureProcessor processor : this.getProjection().getProcessors()) {
                settings.popProcessor(processor);
            }
        }
        return settings;
    }
}

