/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.tree.PalmTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftLeavesFixer;

public class CurvedPalmTreeFeature
extends PalmTreeFeature {
    private static final int Z_PLUS = 0;
    private static final int Z_MINUS = 1;
    private static final int X_PLUS = 2;
    private static final int X_MINUS = 3;
    private static final int TOP_OFFSET = 3;
    private static final int WATER_SEARCH_DIST = 10;
    private int originX;
    private int originZ;
    private int dir;

    public CurvedPalmTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int yy;
        int xx;
        WorldGenLevel world = context.level();
        RandomSource random = context.random();
        BlockPos pos = context.origin();
        pos = pos.immutable();
        int height = 9 + random.nextInt(3);
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.getY(), height)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isBBAvailable(world, pos, height)) {
            return false;
        }
        if (!this.getSapling().defaultBlockState().canSurvive((LevelReader)world, pos)) {
            return false;
        }
        if (world.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK)) {
            world.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 3);
        }
        HashSet logs = Sets.newHashSet();
        HashSet leaves = Sets.newHashSet();
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int dir = this.pickDirection((LevelSimulatedRW)world, random, x, z);
        this.setDir(dir);
        this.setOrigin(x, z);
        for (xx = 0; xx < 4; ++xx) {
            for (yy = 0; yy < height; ++yy) {
                BlockPos posWithDir = this.getPosWithDir(xx, yy + y, 0);
                if (this.isAir((LevelReader)world, posWithDir)) continue;
                return false;
            }
        }
        for (xx = 0; xx < 9; ++xx) {
            for (int zz = 0; zz < 9; ++zz) {
                for (int yy2 = height - 3; yy2 < height + 4; ++yy2) {
                    if (this.isAir((LevelReader)world, this.getPosWithDir(xx + 3, yy2 + y, zz))) continue;
                    return false;
                }
            }
        }
        xx = 0;
        for (yy = 0; yy < height; ++yy) {
            this.placeBlockWithDir(logs, (LevelWriter)world, xx, yy + y, 0, this.getLog());
            if (yy == 0 || yy == 1 || yy == 3) {
                this.placeBlockWithDir(logs, (LevelWriter)world, ++xx, yy + y, 0, this.getLog());
            }
            if (yy != height - 2) continue;
            CurvedPalmTreeFeature.spawnCoconuts((LevelSimulatedRW)world, this.getPosWithDir(xx, yy + y, 0), random, 2, this.getLeaf());
        }
        this.setOrigin(this.getActualXAt(3, 0), this.getActualZAt(3, 0));
        for (int yy3 = 1; yy3 < 5; ++yy3) {
            if (yy3 == 4) {
                this.placeBlockWithDir(leaves, (LevelWriter)world, 1, yy3 + y + height - 1, 0, this.getLeaf());
                continue;
            }
            this.placeBlockWithDir(leaves, (LevelWriter)world, 0, yy3 + y + height - 1, 0, this.getLeaf());
        }
        for (int curDir = 0; curDir < 4; ++curDir) {
            this.setDir(curDir);
            yy = height - 1;
            this.placeBlockWithDir(leaves, (LevelWriter)world, 1, yy - 1 + y, 1, this.getLeaf());
            this.placeBlockWithDir(leaves, (LevelWriter)world, 2, yy - 2 + y, 1, this.getLeaf());
            this.placeBlockWithDir(leaves, (LevelWriter)world, 1, yy - 2 + y, 2, this.getLeaf());
            this.placeBlockWithDir(leaves, (LevelWriter)world, 2, yy - 3 + y, 2, this.getLeaf());
            this.placeBlockWithDir(leaves, (LevelWriter)world, 1, yy + 1 + y, 1, this.getLeaf());
            this.placeBlockWithDir(leaves, (LevelWriter)world, 2, yy + 2 + y, 1, this.getLeaf());
            this.placeBlockWithDir(leaves, (LevelWriter)world, 1, yy + 2 + y, 2, this.getLeaf());
            this.placeBlockWithDir(leaves, (LevelWriter)world, 2, yy + 3 + y, 2, this.getLeaf());
            for (int xx2 = 1; xx2 < 5; ++xx2) {
                if (xx2 == 4) {
                    --yy;
                }
                this.placeBlockWithDir(leaves, (LevelWriter)world, xx2, yy + y, 0, this.getLeaf());
            }
        }
        return TropicraftLeavesFixer.updateLeaves((LevelAccessor)world, logs, leaves);
    }

    private int findWater(LevelSimulatedRW world, RandomSource rand, int x, int z) {
        int iPos;
        int iNeg = 0;
        int kPos = 0;
        int kNeg = 0;
        for (iPos = 0; iPos < 10 && !CurvedPalmTreeFeature.isWater(world, new BlockPos(x + iPos, 127, z)); ++iPos) {
        }
        while (iNeg > -10 && !CurvedPalmTreeFeature.isWater(world, new BlockPos(x + iNeg, 127, z))) {
            --iNeg;
        }
        while (kPos < 10 && !CurvedPalmTreeFeature.isWater(world, new BlockPos(x, 127, z + kPos))) {
            ++kPos;
        }
        while (kNeg > -10 && !CurvedPalmTreeFeature.isWater(world, new BlockPos(x, 127, z + kNeg))) {
            --kNeg;
        }
        if (iPos < Math.abs(iNeg) && iPos < kPos && iPos < Math.abs(kNeg)) {
            return 2;
        }
        if (Math.abs(iNeg) < iPos && Math.abs(iNeg) < kPos && Math.abs(iNeg) < Math.abs(kNeg)) {
            return 3;
        }
        if (kPos < Math.abs(iNeg) && kPos < iPos && kPos < Math.abs(kNeg)) {
            return 0;
        }
        if (Math.abs(kNeg) < Math.abs(iNeg) && Math.abs(kNeg) < iPos && Math.abs(kNeg) < kPos) {
            return 1;
        }
        if (iPos < 10 && iPos == Math.abs(iNeg)) {
            return rand.nextInt(2) + 1;
        }
        if (iPos < 10 && iPos == kPos) {
            if (rand.nextInt(2) + 1 == 1) {
                return 2;
            }
            return 0;
        }
        if (iPos < 10 && iPos == Math.abs(kNeg)) {
            if (rand.nextInt(2) + 1 == 1) {
                return 2;
            }
            return 1;
        }
        if (kPos < 10 && Math.abs(iNeg) == kPos) {
            if (rand.nextInt(2) + 1 == 1) {
                return 3;
            }
            return 0;
        }
        if (Math.abs(iNeg) < 10 && Math.abs(iNeg) == Math.abs(kNeg)) {
            if (rand.nextInt(2) + 1 == 1) {
                return 3;
            }
            return 1;
        }
        if (kPos < 10 && kPos == Math.abs(kNeg)) {
            if (rand.nextInt(2) + 1 == 1) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    private static boolean isWater(LevelSimulatedRW world, BlockPos pos) {
        return world.isStateAtPosition(pos, state -> state.is(Blocks.WATER));
    }

    private int pickDirection(LevelSimulatedRW world, RandomSource rand, int x, int z) {
        int direction = this.findWater(world, rand, x, z);
        if (direction != -1) {
            return direction;
        }
        return rand.nextInt(4);
    }

    private void setOrigin(int originX, int originZ) {
        this.originX = originX;
        this.originZ = originZ;
    }

    private void setDir(int dir) {
        this.dir = dir;
    }

    private BlockPos getPosWithDir(int x, int y, int z) {
        return this.getPosWithDir(this.pos(x, y, z));
    }

    private BlockPos getPosWithDir(BlockPos unRotatedPos) {
        int i = unRotatedPos.getX();
        int j = unRotatedPos.getY();
        int k = unRotatedPos.getZ();
        return switch (this.dir) {
            case 2 -> this.pos(this.originX + i, j, this.originZ + k);
            case 0 -> this.pos(this.originX + k, j, this.originZ - i);
            case 3 -> this.pos(this.originX - i, j, this.originZ - k);
            case 1 -> this.pos(this.originX - k, j, this.originZ + i);
            default -> BlockPos.ZERO;
        };
    }

    private void placeBlockWithDir(Set<BlockPos> positions, LevelWriter world, int x, int y, int z, BlockState state) {
        switch (this.dir) {
            case 2: {
                positions.add(this.pos(this.originX + x, y, this.originZ + z).immutable());
                this.setBlock(world, this.pos(this.originX + x, y, this.originZ + z), state);
                return;
            }
            case 0: {
                positions.add(this.pos(this.originX + z, y, this.originZ - x).immutable());
                this.setBlock(world, this.pos(this.originX + z, y, this.originZ - x), state);
                return;
            }
            case 3: {
                positions.add(this.pos(this.originX - x, y, this.originZ - z).immutable());
                this.setBlock(world, this.pos(this.originX - x, y, this.originZ - z), state);
                return;
            }
            case 1: {
                positions.add(this.pos(this.originX - z, y, this.originZ + x).immutable());
                this.setBlock(world, this.pos(this.originX - z, y, this.originZ + x), state);
            }
        }
    }

    private int getActualXAt(int i, int k) {
        return switch (this.dir) {
            case 2 -> this.originX + i;
            case 0 -> this.originX + k;
            case 3 -> this.originX - i;
            case 1 -> this.originX - k;
            default -> this.originX;
        };
    }

    private int getActualZAt(int i, int k) {
        return switch (this.dir) {
            case 2 -> this.originZ + k;
            case 0 -> this.originZ - i;
            case 3 -> this.originZ - k;
            case 1 -> this.originZ + i;
            default -> this.originZ;
        };
    }

    public BlockPos pos(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }
}

