/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.tree.PalmTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftLeavesFixer;

public class LargePalmTreeFeature
extends PalmTreeFeature {
    public LargePalmTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        RandomSource random = context.random();
        BlockPos pos = context.origin();
        pos = pos.immutable();
        int height = random.nextInt(7) + 7;
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.getY(), height)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isBBAvailable(world, pos, height)) {
            return false;
        }
        if (!this.getSapling().defaultBlockState().canSurvive((LevelReader)world, pos)) {
            return false;
        }
        if (world.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK)) {
            world.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 3);
        }
        HashSet logs = Sets.newHashSet();
        HashSet leaves = Sets.newHashSet();
        for (int y = 0; y <= height; ++y) {
            this.placeLog(logs, (LevelSimulatedRW)world, pos.getX(), pos.getY() + y, pos.getZ());
        }
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 0, j + height + 1, k + -7);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -1, j + height + 1, k + -6);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 1, k + -6);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -5, j + height + 1, k + -5);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 5, j + height + 1, k + -5);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -6, j + height + 1, k + -1);
        this.placeLog(leaves, (LevelSimulatedRW)world, i + 0, j + height + 1, k + -1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 6, j + height + 1, k + -1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -7, j + height + 1, k + 0);
        this.placeLog(leaves, (LevelSimulatedRW)world, i + -1, j + height + 1, k + 0);
        this.placeLog(leaves, (LevelSimulatedRW)world, i + 0, j + height + 1, k + 0);
        this.placeLog(leaves, (LevelSimulatedRW)world, i + 1, j + height + 1, k + 0);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 7, j + height + 1, k + 0);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -6, j + height + 1, k + 1);
        this.placeLog(leaves, (LevelSimulatedRW)world, i + 0, j + height + 1, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 6, j + height + 1, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -5, j + height + 1, k + 5);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 5, j + height + 1, k + 5);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -1, j + height + 1, k + 6);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 1, k + 6);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 0, j + height + 1, k + 7);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 0, j + height + 2, k + -6);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -4, j + height + 2, k + -5);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -1, j + height + 2, k + -5);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 2, k + -5);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 4, j + height + 2, k + -5);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -5, j + height + 2, k + -4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -3, j + height + 2, k + -4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -1, j + height + 2, k + -4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 2, k + -4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 3, j + height + 2, k + -4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 5, j + height + 2, k + -4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -4, j + height + 2, k + -3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -2, j + height + 2, k + -3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -1, j + height + 2, k + -3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 2, k + -3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 2, j + height + 2, k + -3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 4, j + height + 2, k + -3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -3, j + height + 2, k + -2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -1, j + height + 2, k + -2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 2, k + -2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 3, j + height + 2, k + -2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -5, j + height + 2, k + -1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -4, j + height + 2, k + -1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -3, j + height + 2, k + -1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -2, j + height + 2, k + -1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -1, j + height + 2, k + -1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 0, j + height + 2, k + -1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 2, k + -1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 2, j + height + 2, k + -1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 3, j + height + 2, k + -1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 4, j + height + 2, k + -1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 5, j + height + 2, k + -1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -6, j + height + 2, k + 0);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -1, j + height + 2, k + 0);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 0, j + height + 2, k + 0);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 2, k + 0);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 6, j + height + 2, k + 0);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -5, j + height + 2, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -4, j + height + 2, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -3, j + height + 2, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -2, j + height + 2, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -1, j + height + 2, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 0, j + height + 2, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 2, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 2, j + height + 2, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 3, j + height + 2, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 4, j + height + 2, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 5, j + height + 2, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -3, j + height + 2, k + 2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -1, j + height + 2, k + 2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 2, k + 2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 3, j + height + 2, k + 2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -4, j + height + 2, k + 3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -2, j + height + 2, k + 3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -1, j + height + 2, k + 3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 2, k + 3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 2, j + height + 2, k + 3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 4, j + height + 2, k + 3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -5, j + height + 2, k + 4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -3, j + height + 2, k + 4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -1, j + height + 2, k + 4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 2, k + 4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 3, j + height + 2, k + 4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 5, j + height + 2, k + 4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -4, j + height + 2, k + 5);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -1, j + height + 2, k + 5);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 2, k + 5);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 4, j + height + 2, k + 5);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 0, j + height + 2, k + 6);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 0, j + height + 3, k + -5);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -4, j + height + 3, k + -4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 0, j + height + 3, k + -4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 4, j + height + 3, k + -4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -3, j + height + 3, k + -3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 0, j + height + 3, k + -3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 3, j + height + 3, k + -3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -2, j + height + 3, k + -2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 0, j + height + 3, k + -2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 2, j + height + 3, k + -2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -1, j + height + 3, k + -1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 0, j + height + 3, k + -1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 3, k + -1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -5, j + height + 3, k + 0);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -4, j + height + 3, k + 0);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -3, j + height + 3, k + 0);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -2, j + height + 3, k + 0);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -1, j + height + 3, k + 0);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 3, k + 0);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 2, j + height + 3, k + 0);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 3, j + height + 3, k + 0);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 4, j + height + 3, k + 0);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 5, j + height + 3, k + 0);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -1, j + height + 3, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 0, j + height + 3, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 1, j + height + 3, k + 1);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -2, j + height + 3, k + 2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 0, j + height + 3, k + 2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 2, j + height + 3, k + 2);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -3, j + height + 3, k + 3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 0, j + height + 3, k + 3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 3, j + height + 3, k + 3);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + -4, j + height + 3, k + 4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 0, j + height + 3, k + 4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 4, j + height + 3, k + 4);
        this.placeLeaf(leaves, (LevelSimulatedRW)world, i + 0, j + height + 3, k + 5);
        for (int c = 0; c < 4; ++c) {
            LargePalmTreeFeature.spawnCoconuts((LevelSimulatedRW)world, new BlockPos(i, j + height + 1, k).relative(Direction.from2DDataValue((int)i)), random, 2, this.getLeaf());
        }
        return TropicraftLeavesFixer.updateLeaves((LevelAccessor)world, logs, leaves);
    }
}

