/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.block.CoconutBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;
import org.apache.commons.lang3.ArrayUtils;

public abstract class PalmTreeFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Direction[] DIRECTIONS = (Direction[])ArrayUtils.removeElement((Object[])Direction.values(), (Object)Direction.UP);

    public PalmTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    protected SaplingBlock getSapling() {
        return (SaplingBlock)TropicraftBlocks.PALM_SAPLING.get();
    }

    protected final BlockState getLeaf() {
        return ((LeavesBlock)TropicraftBlocks.PALM_LEAVES.get()).defaultBlockState();
    }

    protected final BlockState getLog() {
        return ((RotatedPillarBlock)TropicraftBlocks.PALM_LOG.get()).defaultBlockState();
    }

    protected boolean isAir(LevelReader level, BlockPos pos) {
        return level.isEmptyBlock(pos);
    }

    protected void placeLeaf(Set<BlockPos> leaves, LevelSimulatedRW world, int x, int y, int z) {
        this.placeLeaf(leaves, world, new BlockPos(x, y, z));
    }

    protected void placeLeaf(Set<BlockPos> leaves, LevelSimulatedRW world, BlockPos pos) {
        if (TreeFeature.validTreePos((LevelSimulatedReader)world, (BlockPos)pos)) {
            leaves.add(pos.immutable());
            world.setBlock(pos, this.getLeaf(), 19);
        }
    }

    protected void placeLog(Set<BlockPos> logs, LevelSimulatedRW world, int x, int y, int z) {
        this.placeLog(logs, world, new BlockPos(x, y, z));
    }

    protected void placeLog(Set<BlockPos> logs, LevelSimulatedRW world, BlockPos pos) {
        if (TreeFeature.validTreePos((LevelSimulatedReader)world, (BlockPos)pos)) {
            logs.add(pos.immutable());
            world.setBlock(pos, this.getLog(), 19);
        }
    }

    public static void spawnCoconuts(LevelSimulatedRW world, BlockPos pos, RandomSource random, int chance, BlockState leaf) {
        BlockState coconut = ((CoconutBlock)((Object)TropicraftBlocks.COCONUT.get())).defaultBlockState();
        for (Direction d : DIRECTIONS) {
            BlockPos pos2 = pos.relative(d);
            if (random.nextInt(chance) != 0 || !TreeFeature.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)pos2)) continue;
            world.setBlock(pos2, (BlockState)coconut.setValue((Property)CoconutBlock.FACING, (Comparable)d.getOpposite()), 3);
        }
    }
}

