/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.tree.RainforestTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftLeavesFixer;

public class TallRainforestTreeFeature
extends RainforestTreeFeature {
    public static final List<BlockPos> BRANCH_DIRECTIONS = BlockPos.betweenClosedStream((int)-1, (int)0, (int)-1, (int)1, (int)0, (int)1).map(BlockPos::immutable).filter(blockPos -> !blockPos.equals((Object)BlockPos.ZERO)).toList();
    private static final int VINE_CHANCE = 5;
    private static final int SMALL_LEAF_CHANCE = 3;
    private static final int SECOND_CANOPY_CHANCE = 3;

    public TallRainforestTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    private boolean isSoil(LevelAccessor world, BlockPos pos) {
        return this.getSapling().defaultBlockState().canSurvive((LevelReader)world, pos);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        RandomSource rand = context.random();
        BlockPos pos = context.origin();
        pos = pos.immutable();
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        int height = rand.nextInt(15) + 15;
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.getY(), height)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isBBAvailable(world, pos, height)) {
            return false;
        }
        if (!this.isSoil((LevelAccessor)world, pos.below())) {
            return false;
        }
        if (!this.isSoil((LevelAccessor)world, pos.east().below())) {
            return false;
        }
        if (!this.isSoil((LevelAccessor)world, pos.west().below())) {
            return false;
        }
        if (!this.isSoil((LevelAccessor)world, pos.north().below())) {
            return false;
        }
        if (!this.isSoil((LevelAccessor)world, pos.south().below())) {
            return false;
        }
        HashSet logs = Sets.newHashSet();
        HashSet leaves = Sets.newHashSet();
        this.setState(null, (LevelWriter)world, new BlockPos(i, j - 1, k), Blocks.DIRT.defaultBlockState());
        this.setState(null, (LevelWriter)world, new BlockPos(i - 1, j - 1, k), Blocks.DIRT.defaultBlockState());
        this.setState(null, (LevelWriter)world, new BlockPos(i + 1, j - 1, k), Blocks.DIRT.defaultBlockState());
        this.setState(null, (LevelWriter)world, new BlockPos(i, j - 1, k - 1), Blocks.DIRT.defaultBlockState());
        this.setState(null, (LevelWriter)world, new BlockPos(i, j - 1, k + 1), Blocks.DIRT.defaultBlockState());
        for (int y = j; y < j + height; ++y) {
            int nz;
            int nx;
            this.placeLog(logs, (LevelSimulatedRW)world, i, y, k);
            this.placeLog(logs, (LevelSimulatedRW)world, i - 1, y, k);
            this.placeLog(logs, (LevelSimulatedRW)world, i + 1, y, k);
            this.placeLog(logs, (LevelSimulatedRW)world, i, y, k - 1);
            this.placeLog(logs, (LevelSimulatedRW)world, i, y, k + 1);
            if (y - j > height / 2 && rand.nextInt(3) == 0) {
                nx = rand.nextInt(3) - 1 + i;
                nz = rand.nextInt(3) - 1 + k;
                this.genCircle(leaves, (LevelSimulatedRW)world, new BlockPos(nx, y + 1, nz), 1.0, 0.0, this.getLeaf(), false);
                this.genCircle(leaves, (LevelSimulatedRW)world, nx, y, nz, 2.0, 1.0, this.getLeaf(), false);
            }
            if (y - j <= height - height / 4 || y - j >= height - 3 || rand.nextInt(3) != 0) continue;
            nx = i + rand.nextInt(9) - 4;
            nz = k + rand.nextInt(9) - 4;
            int leafSize = rand.nextInt(3) + 5;
            this.genCircle(leaves, (LevelSimulatedRW)world, nx, y + 3, nz, leafSize - 2, 0.0, this.getLeaf(), false);
            this.genCircle(leaves, (LevelSimulatedRW)world, nx, y + 2, nz, leafSize - 1, leafSize - 3, this.getLeaf(), false);
            this.genCircle(leaves, (LevelSimulatedRW)world, nx, y + 1, nz, leafSize, leafSize - 1, this.getLeaf(), false);
            this.placeBlockLine(logs, (LevelSimulatedRW)world, new int[]{i, y - 2, k}, new int[]{nx, y + 2, nz}, this.getLog());
        }
        int leafSize = rand.nextInt(5) + 9;
        this.genCircle(leaves, (LevelSimulatedRW)world, i, j + height, k, leafSize - 2, 0.0, this.getLeaf(), false);
        this.genCircle(leaves, (LevelSimulatedRW)world, i, j + height - 1, k, leafSize - 1, leafSize - 4, this.getLeaf(), false);
        this.genCircle(leaves, (LevelSimulatedRW)world, i, j + height - 2, k, leafSize, leafSize - 1, this.getLeaf(), false);
        for (BlockPos direction : BRANCH_DIRECTIONS) {
            BlockPos endPos = direction.distManhattan((Vec3i)BlockPos.ZERO) > 1 ? new BlockPos(i, j, k).offset((Vec3i)direction.multiply(leafSize / 2)) : new BlockPos(i, j, k).offset((Vec3i)direction.multiply(leafSize - 4));
            endPos = endPos.offset(1 - rand.nextInt(3), 0, 1 - rand.nextInt(3));
            this.placeBlockLine(logs, (LevelSimulatedRW)world, new int[]{i, j + height - 1, k}, new int[]{endPos.getX(), j + height - 1, endPos.getZ()}, this.getLog());
        }
        return TropicraftLeavesFixer.updateLeaves((LevelAccessor)world, logs, leaves);
    }
}

