/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTreeDecorators;
import net.tropicraft.core.common.entity.TropicraftEntities;

public class TropibeehiveDecorator
extends TreeDecorator {
    public static final MapCodec<TropibeehiveDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(TropibeehiveDecorator::new, beehive -> Float.valueOf(beehive.probability));
    private static final Direction WORLDGEN_FACING = Direction.SOUTH;
    private static final Direction[] SPAWN_DIRECTIONS = (Direction[])Direction.Plane.HORIZONTAL.stream().filter(p_202307_ -> p_202307_ != WORLDGEN_FACING.getOpposite()).toArray(Direction[]::new);
    private final float probability;

    public TropibeehiveDecorator(float probability) {
        this.probability = probability;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)TropicraftTreeDecorators.TROPIBEEHIVE.get();
    }

    public void place(TreeDecorator.Context pContext) {
        RandomSource randomsource = pContext.random();
        if (!(randomsource.nextFloat() >= this.probability)) {
            ObjectArrayList list = pContext.leaves();
            ObjectArrayList list1 = pContext.logs();
            int i = !list.isEmpty() ? Math.max(((BlockPos)list.get(0)).getY() - 1, ((BlockPos)list1.get(0)).getY() + 1) : Math.min(((BlockPos)list1.get(0)).getY() + 1 + randomsource.nextInt(3), ((BlockPos)list1.get(list1.size() - 1)).getY());
            List list2 = list1.stream().filter(p_202300_ -> p_202300_.getY() == i).flatMap(p_202305_ -> Stream.of(SPAWN_DIRECTIONS).map(arg_0 -> ((BlockPos)p_202305_).relative(arg_0))).collect(Collectors.toList());
            if (!list2.isEmpty()) {
                Collections.shuffle(list2);
                Optional<BlockPos> optional = list2.stream().filter(p_226022_ -> pContext.isAir(p_226022_) && pContext.isAir(p_226022_.relative(WORLDGEN_FACING))).findFirst();
                if (!optional.isEmpty()) {
                    pContext.setBlock(optional.get(), (BlockState)Blocks.BEE_NEST.defaultBlockState().setValue((Property)BeehiveBlock.FACING, (Comparable)WORLDGEN_FACING));
                    pContext.level().getBlockEntity(optional.get(), BlockEntityType.BEEHIVE).ifPresent(p_330149_ -> {
                        int j = 2 + randomsource.nextInt(2);
                        for (int k = 0; k < j; ++k) {
                            p_330149_.storeBee(TropibeehiveDecorator.tropibeeOccupant(599));
                        }
                    });
                }
            }
        }
    }

    public static BeehiveBlockEntity.Occupant tropibeeOccupant(int pTicksInHive) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)TropicraftEntities.TROPI_BEE.get())).toString());
        return new BeehiveBlockEntity.Occupant(CustomData.of((CompoundTag)compoundtag), pTicksInHive, 600);
    }
}

