/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.tree.RainforestTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftLeavesFixer;

public class TualungFeature
extends RainforestTreeFeature {
    private final int baseHeight;
    private final int maxHeight;

    public TualungFeature(Codec<NoneFeatureConfiguration> codec, int maxHeight, int baseHeight) {
        super(codec);
        this.baseHeight = baseHeight;
        this.maxHeight = maxHeight;
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        RandomSource rand = context.random();
        BlockPos pos = context.origin();
        pos = pos.immutable();
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        int height = rand.nextInt(this.maxHeight - this.baseHeight) + this.baseHeight + j;
        int branches = rand.nextInt(3) + 3;
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.getY(), height - j)) {
            return false;
        }
        if (height + 6 > world.getMaxBuildHeight()) {
            return false;
        }
        if (!TropicraftFeatureUtil.isBBAvailable(world, pos, height - j)) {
            return false;
        }
        if (!this.getSapling().defaultBlockState().canSurvive((LevelReader)world, pos)) {
            return false;
        }
        HashSet logs = Sets.newHashSet();
        HashSet leaves = Sets.newHashSet();
        this.setState(null, (LevelWriter)world, new BlockPos(i, j - 1, k), Blocks.DIRT.defaultBlockState());
        this.setState(null, (LevelWriter)world, new BlockPos(i - 1, j - 1, k), Blocks.DIRT.defaultBlockState());
        this.setState(null, (LevelWriter)world, new BlockPos(i + 1, j - 1, k), Blocks.DIRT.defaultBlockState());
        this.setState(null, (LevelWriter)world, new BlockPos(i, j - 1, k - 1), Blocks.DIRT.defaultBlockState());
        this.setState(null, (LevelWriter)world, new BlockPos(i, j - 1, k + 1), Blocks.DIRT.defaultBlockState());
        for (int y = j; y < height; ++y) {
            this.placeLog(logs, (LevelSimulatedRW)world, i, y, k);
            this.placeLog(logs, (LevelSimulatedRW)world, i - 1, y, k);
            this.placeLog(logs, (LevelSimulatedRW)world, i + 1, y, k);
            this.placeLog(logs, (LevelSimulatedRW)world, i, y, k - 1);
            this.placeLog(logs, (LevelSimulatedRW)world, i, y, k + 1);
        }
        for (int x = 0; x < branches; ++x) {
            int branchHeight = rand.nextInt(4) + 2 + height;
            int bx = rand.nextInt(15) - 8 + i;
            int bz = rand.nextInt(15) - 8 + k;
            this.placeBlockLine(logs, (LevelSimulatedRW)world, new int[]{i + this.sign((bx - i) / 2), height, k + this.sign((bz - k) / 2)}, new int[]{bx, branchHeight, bz}, this.getLog());
            this.genCircle(leaves, (LevelSimulatedRW)world, bx, branchHeight, bz, 2.0, 1.0, this.getLeaf(), false);
            this.genCircle(leaves, (LevelSimulatedRW)world, bx, branchHeight + 1, bz, 3.0, 2.0, this.getLeaf(), false);
        }
        return TropicraftLeavesFixer.updateLeaves((LevelAccessor)world, logs, leaves);
    }

    private int sign(int i) {
        return i == 0 ? 0 : (i <= 0 ? -1 : 1);
    }
}

