/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.noise;

import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.SurfaceRuleData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.dimension.TropicraftSurfaces;
import net.tropicraft.core.common.dimension.noise.TropicraftNoiseRouterData;

public final class TropicraftNoiseGenSettings {
    public static final ResourceKey<NoiseGeneratorSettings> TROPICS = TropicraftNoiseGenSettings.createKey("tropics");

    public static void bootstrap(BootstrapContext<NoiseGeneratorSettings> context) {
        HolderGetter densityFunctions = context.lookup(Registries.DENSITY_FUNCTION);
        HolderGetter noiseParameters = context.lookup(Registries.NOISE);
        context.register(TROPICS, (Object)TropicraftNoiseGenSettings.createNoise((HolderGetter<DensityFunction>)densityFunctions, (HolderGetter<NormalNoise.NoiseParameters>)noiseParameters, true));
    }

    public static NoiseGeneratorSettings createNoise(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters, boolean tropisurface) {
        NoiseSettings settings = NoiseSettings.create((int)-64, (int)384, (int)1, (int)2);
        SurfaceRules.RuleSource surface = tropisurface ? TropicraftSurfaces.tropics() : SurfaceRuleData.overworld();
        return new NoiseGeneratorSettings(settings, Blocks.STONE.defaultBlockState(), Blocks.WATER.defaultBlockState(), TropicraftNoiseRouterData.tropics(densityFunctions, noiseParameters), surface, List.of(), 127, false, true, true, true);
    }

    private static ResourceKey<NoiseGeneratorSettings> createKey(String name) {
        return Tropicraft.resourceKey(Registries.NOISE_SETTINGS, name);
    }
}

