/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.drinks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.DrinkIngredient;

public record Cocktail(Optional<Holder<Drink>> drink, List<Holder<DrinkIngredient>> ingredients, int color) {
    public static final int DEFAULT_COLOR = 15973942;
    public static final Cocktail EMPTY = new Cocktail(Optional.empty(), List.of(), 15973942);
    private static final Codec<Cocktail> FULL_CODEC = RecordCodecBuilder.create(i -> i.group((App)Drink.CODEC.optionalFieldOf("drink").forGetter(Cocktail::drink), (App)DrinkIngredient.CODEC.listOf().optionalFieldOf("ingredients", List.of()).forGetter(Cocktail::ingredients)).apply((Applicative)i, Cocktail::new));
    public static final Codec<Cocktail> CODEC = Codec.withAlternative(FULL_CODEC, Drink.CODEC, Cocktail::ofDrink);
    public static final StreamCodec<RegistryFriendlyByteBuf, Cocktail> STREAM_CODEC = StreamCodec.composite((StreamCodec)Drink.STREAM_CODEC.apply(ByteBufCodecs::optional), Cocktail::drink, (StreamCodec)DrinkIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), Cocktail::ingredients, Cocktail::new);

    public Cocktail(Optional<Holder<Drink>> drink, List<Holder<DrinkIngredient>> ingredients) {
        this(drink, ingredients, Cocktail.computeColor(drink, ingredients));
    }

    public static Cocktail ofDrink(Holder<Drink> drink) {
        return new Cocktail(Optional.of(drink), List.of());
    }

    public static Cocktail ofIngredients(List<Holder<DrinkIngredient>> ingredients) {
        if (ingredients.isEmpty()) {
            throw new IllegalArgumentException("Cannot create drink with no ingredients");
        }
        return new Cocktail(Optional.empty(), List.copyOf(ingredients));
    }

    private static int computeColor(Optional<Holder<Drink>> drink, List<Holder<DrinkIngredient>> ingredients) {
        if (drink.isPresent()) {
            return ((Drink)drink.get().value()).color();
        }
        int red = 0;
        int green = 0;
        int blue = 0;
        float weight = 0.0f;
        for (Holder<DrinkIngredient> ingredient : ingredients) {
            int color = ((DrinkIngredient)ingredient.value()).color();
            red += FastColor.ARGB32.red((int)color);
            green += FastColor.ARGB32.green((int)color);
            blue += FastColor.ARGB32.blue((int)color);
            weight += ((DrinkIngredient)ingredient.value()).weight();
        }
        return FastColor.ARGB32.color((int)255, (int)Mth.floor((float)((float)red / weight)), (int)Mth.floor((float)((float)green / weight)), (int)Mth.floor((float)((float)blue / weight)));
    }

    public void onDrink(ServerPlayer player) {
        this.drink.ifPresent(holder -> ((Drink)holder.value()).onDrink(player));
    }
}

