/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class IkWalker {
    private static final double STEP_DISTANCE = 0.25;
    private static final double STEP_NOW_DISTANCE = 0.4;
    private static final double RESET_DISTANCE = 1.5;
    private static final double MIN_SETTLE_DISTANCE = 0.05;
    private final int stepLengthTicks;
    private final int stepIntervalTicks;
    private final int settleDelayTicks;
    private final float stepAhead;
    private final List<Foot> feet = new ArrayList<Foot>();
    private int stepDelayTicks;

    public IkWalker(int stepLengthTicks, int stepIntervalTicks, int settleDelayTicks, float stepAhead) {
        this.stepLengthTicks = stepLengthTicks;
        this.stepIntervalTicks = stepIntervalTicks;
        this.settleDelayTicks = settleDelayTicks;
        this.stepAhead = stepAhead;
    }

    public Foot addFoot(float forward, float right) {
        Foot foot = new Foot(forward, right);
        this.feet.add(foot);
        return foot;
    }

    public void reset(Mob entity) {
        EntitySpace entitySpace = EntitySpace.from(entity);
        for (Foot foot : this.feet) {
            foot.reset(entitySpace);
        }
    }

    public void update(Mob entity) {
        boolean waitingToStep;
        boolean moving = entity.walkAnimation.isMoving();
        EntitySpace entitySpace = EntitySpace.from(entity);
        boolean bl = waitingToStep = this.stepDelayTicks > 0;
        if (waitingToStep) {
            --this.stepDelayTicks;
        }
        boolean anyStepping = false;
        for (Foot foot : this.feet) {
            if (entity.onGround()) {
                foot.updateOnGround(entitySpace, moving, waitingToStep, anyStepping);
            } else {
                foot.updateInAir(entitySpace);
            }
            anyStepping |= foot.isStepping();
        }
        if (anyStepping) {
            this.stepDelayTicks = this.stepIntervalTicks;
        }
    }

    public class Foot {
        private final float forward;
        private final float right;
        private final Vector2d oldPosition = new Vector2d();
        private final Vector2d position = new Vector2d();
        @Nullable
        private Vector2d lastStepPosition;
        private int stepTicks;
        private int stepLengthTicks;
        private int settleDelayTicks;

        private Foot(float forward, float right) {
            this.forward = forward;
            this.right = right;
        }

        private void reset(EntitySpace entitySpace) {
            this.moveTo(entitySpace.toWorldSpace(this.forward, this.right));
            this.oldPosition.set((Vector2dc)this.position);
        }

        private void updateOnGround(EntitySpace entitySpace, boolean moving, boolean waitingToStep, boolean anyFootStepping) {
            Vector2d settleTarget;
            double distanceSq;
            this.oldPosition.set((Vector2dc)this.position);
            if (this.lastStepPosition != null && ++this.stepTicks >= this.stepLengthTicks) {
                this.lastStepPosition = null;
                this.stepTicks = 0;
            }
            if (this.settleDelayTicks > 0) {
                --this.settleDelayTicks;
            }
            if ((distanceSq = this.position.distanceSquared((Vector2dc)(settleTarget = entitySpace.toWorldSpace(this.forward, this.right)))) > 2.25) {
                this.moveTo(settleTarget);
                return;
            }
            if (this.isStepping() || anyFootStepping) {
                return;
            }
            if (distanceSq > 0.16000000000000003) {
                this.maybeStepTo(settleTarget, distanceSq, 0.0, IkWalker.this.stepLengthTicks / 3);
                return;
            }
            if (!waitingToStep) {
                if (moving) {
                    Vector2d stepTarget = entitySpace.toWorldSpace(this.forward + IkWalker.this.stepAhead, this.right);
                    this.maybeStepTo(stepTarget, distanceSq, 0.25, IkWalker.this.stepLengthTicks);
                } else if (this.settleDelayTicks == 0) {
                    this.maybeStepTo(settleTarget, distanceSq, 0.05, IkWalker.this.stepLengthTicks);
                }
            }
        }

        private void updateInAir(EntitySpace entitySpace) {
            this.oldPosition.set((Vector2dc)this.position);
            this.moveTo(entitySpace.toWorldSpace(this.forward, this.right));
        }

        private void maybeStepTo(Vector2d target, double distanceSq, double minDistance, int lengthTicks) {
            if (distanceSq < minDistance * minDistance) {
                return;
            }
            this.lastStepPosition = new Vector2d((Vector2dc)this.position);
            this.oldPosition.set((Vector2dc)target);
            this.position.set((Vector2dc)target);
            this.stepLengthTicks = lengthTicks;
            this.settleDelayTicks = IkWalker.this.settleDelayTicks;
        }

        private void moveTo(Vector2d target) {
            this.position.set((Vector2dc)target);
            this.lastStepPosition = null;
            this.stepTicks = 0;
            this.settleDelayTicks = IkWalker.this.settleDelayTicks;
        }

        private Vector2d stepPosition(float partialTicks) {
            return this.oldPosition.lerp((Vector2dc)this.position, (double)partialTicks, new Vector2d());
        }

        public boolean isStepping() {
            return this.lastStepPosition != null;
        }

        public Vector3f solveModelPosition(EntitySpace entitySpace, float partialTicks) {
            Vector3f pos;
            Vector3f stepPos = entitySpace.toLocalSpace(this.stepPosition(partialTicks));
            if (this.lastStepPosition != null) {
                Vector3f lastStep = entitySpace.toLocalSpace(this.lastStepPosition);
                pos = Foot.step(lastStep, stepPos, ((float)this.stepTicks + partialTicks) / (float)this.stepLengthTicks);
            } else {
                pos = stepPos;
            }
            return pos.mul(1.0f, 1.0f, -1.0f);
        }

        private static Vector3f step(Vector3f from, Vector3f to, float progress) {
            Vector3f midpoint = from.add((Vector3fc)to, new Vector3f()).mul(0.5f);
            Vector3f delta = from.sub((Vector3fc)midpoint);
            Vector3f axis = delta.cross(0.0f, 1.0f, 0.0f, new Vector3f()).normalize();
            return delta.rotateAxis(progress * (float)Math.PI, axis.x, axis.y, axis.z).add((Vector3fc)midpoint);
        }
    }

    public record EntitySpace(double x, double z, float sin, float cos) {
        public EntitySpace(double x, double z, float yRot) {
            this(x, z, Mth.sin((float)(-yRot * ((float)Math.PI / 180))), Mth.cos((float)(-yRot * ((float)Math.PI / 180))));
        }

        public static EntitySpace from(Mob entity) {
            return new EntitySpace(entity.getX(), entity.getZ(), entity.yBodyRot);
        }

        public static EntitySpace from(Mob entity, float partialTicks) {
            return new EntitySpace(Mth.lerp((double)partialTicks, (double)entity.xo, (double)entity.getX()), Mth.lerp((double)partialTicks, (double)entity.zo, (double)entity.getZ()), Mth.lerp((float)partialTicks, (float)entity.yBodyRotO, (float)entity.yBodyRot));
        }

        public Vector2d toWorldSpace(float forward, float right) {
            return new Vector2d((double)(-right * this.cos + forward * this.sin), (double)(forward * this.cos - -right * this.sin)).add(this.x, this.z);
        }

        public Vector3f toLocalSpace(Vector2d worldPos) {
            float relativeX = (float)(worldPos.x - this.x);
            float relativeZ = (float)(worldPos.y - this.z);
            return new Vector3f(relativeX * this.cos + relativeZ * -this.sin, 0.0f, relativeZ * this.cos - relativeX * -this.sin);
        }
    }
}

