/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity;

import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.EntityBuilder;
import com.tterrag.registrate.providers.loot.RegistrateEntityLootTables;
import com.tterrag.registrate.util.entry.EntityEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.client.renderer.entity.DolphinRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.ClientSetup;
import net.tropicraft.core.client.entity.render.AshenMaskRenderer;
import net.tropicraft.core.client.entity.render.AshenRenderer;
import net.tropicraft.core.client.entity.render.BambooItemFrameRenderer;
import net.tropicraft.core.client.entity.render.BasiliskLizardRenderer;
import net.tropicraft.core.client.entity.render.BeachFloatRenderer;
import net.tropicraft.core.client.entity.render.ChairRenderer;
import net.tropicraft.core.client.entity.render.CowktailRenderer;
import net.tropicraft.core.client.entity.render.CuberaRenderer;
import net.tropicraft.core.client.entity.render.EIHRenderer;
import net.tropicraft.core.client.entity.render.EagleRayRenderer;
import net.tropicraft.core.client.entity.render.FailgullRenderer;
import net.tropicraft.core.client.entity.render.FiddlerCrabRenderer;
import net.tropicraft.core.client.entity.render.FishingBobberEntityRenderer;
import net.tropicraft.core.client.entity.render.GibnutRenderer;
import net.tropicraft.core.client.entity.render.HummingbirdRenderer;
import net.tropicraft.core.client.entity.render.IguanaRenderer;
import net.tropicraft.core.client.entity.render.JaguarRenderer;
import net.tropicraft.core.client.entity.render.KoaRenderer;
import net.tropicraft.core.client.entity.render.ManOWarRenderer;
import net.tropicraft.core.client.entity.render.ManateeRenderer;
import net.tropicraft.core.client.entity.render.MarlinRenderer;
import net.tropicraft.core.client.entity.render.PapyrusCanaryRenderer;
import net.tropicraft.core.client.entity.render.PapyrusGonolekRenderer;
import net.tropicraft.core.client.entity.render.PiranhaRenderer;
import net.tropicraft.core.client.entity.render.PoisonBlotRenderer;
import net.tropicraft.core.client.entity.render.SardineRenderer;
import net.tropicraft.core.client.entity.render.SeaTurtleRenderer;
import net.tropicraft.core.client.entity.render.SeaUrchinRenderer;
import net.tropicraft.core.client.entity.render.SeahorseRenderer;
import net.tropicraft.core.client.entity.render.SharkRenderer;
import net.tropicraft.core.client.entity.render.ShoebillStorkRenderer;
import net.tropicraft.core.client.entity.render.SlenderHarvestMouseRenderer;
import net.tropicraft.core.client.entity.render.SpearRenderer;
import net.tropicraft.core.client.entity.render.SpiderMonkeyRenderer;
import net.tropicraft.core.client.entity.render.StarfishRenderer;
import net.tropicraft.core.client.entity.render.TapirRenderer;
import net.tropicraft.core.client.entity.render.ToucanRenderer;
import net.tropicraft.core.client.entity.render.TreeFrogRenderer;
import net.tropicraft.core.client.entity.render.TropiBeeRenderer;
import net.tropicraft.core.client.entity.render.TropiCreeperRenderer;
import net.tropicraft.core.client.entity.render.TropiSkellyRenderer;
import net.tropicraft.core.client.entity.render.TropiSpiderRenderer;
import net.tropicraft.core.client.entity.render.TropicraftTropicalFishRenderer;
import net.tropicraft.core.client.entity.render.UmbrellaRenderer;
import net.tropicraft.core.client.entity.render.VMonkeyRenderer;
import net.tropicraft.core.client.entity.render.WallItemRenderer;
import net.tropicraft.core.client.entity.render.WhiteCollaredOlivebackRenderer;
import net.tropicraft.core.client.entity.render.WhiteLippedPeccaryRenderer;
import net.tropicraft.core.client.entity.render.WhiteWingedWarblerRenderer;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.TropicsConfigs;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.entity.BambooItemFrame;
import net.tropicraft.core.common.entity.SeaTurtleEntity;
import net.tropicraft.core.common.entity.TropiBeeEntity;
import net.tropicraft.core.common.entity.egg.EggEntity;
import net.tropicraft.core.common.entity.egg.SeaTurtleEggEntity;
import net.tropicraft.core.common.entity.egg.SeaUrchinEggEntity;
import net.tropicraft.core.common.entity.egg.StarfishEggEntity;
import net.tropicraft.core.common.entity.egg.TropiSpiderEggEntity;
import net.tropicraft.core.common.entity.hostile.AshenEntity;
import net.tropicraft.core.common.entity.hostile.TropiSkellyEntity;
import net.tropicraft.core.common.entity.hostile.TropiSpiderEntity;
import net.tropicraft.core.common.entity.neutral.EIHEntity;
import net.tropicraft.core.common.entity.neutral.IguanaEntity;
import net.tropicraft.core.common.entity.neutral.JaguarEntity;
import net.tropicraft.core.common.entity.neutral.TreeFrogEntity;
import net.tropicraft.core.common.entity.neutral.VMonkeyEntity;
import net.tropicraft.core.common.entity.passive.CowktailEntity;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;
import net.tropicraft.core.common.entity.passive.EntityKoaHunter;
import net.tropicraft.core.common.entity.passive.FailgullEntity;
import net.tropicraft.core.common.entity.passive.FiddlerCrabEntity;
import net.tropicraft.core.common.entity.passive.FishingBobberEntity;
import net.tropicraft.core.common.entity.passive.GibnutEntity;
import net.tropicraft.core.common.entity.passive.HummingbirdEntity;
import net.tropicraft.core.common.entity.passive.ShoebillStorkEntity;
import net.tropicraft.core.common.entity.passive.SlenderHarvestMouseEntity;
import net.tropicraft.core.common.entity.passive.SmallBirdEntity;
import net.tropicraft.core.common.entity.passive.TapirEntity;
import net.tropicraft.core.common.entity.passive.ToucanEntity;
import net.tropicraft.core.common.entity.passive.TropiCreeperEntity;
import net.tropicraft.core.common.entity.passive.WhiteLippedPeccaryEntity;
import net.tropicraft.core.common.entity.passive.basilisk.BasiliskLizardEntity;
import net.tropicraft.core.common.entity.passive.monkey.SpiderMonkeyEntity;
import net.tropicraft.core.common.entity.placeable.AshenMaskEntity;
import net.tropicraft.core.common.entity.placeable.BeachFloatEntity;
import net.tropicraft.core.common.entity.placeable.ChairEntity;
import net.tropicraft.core.common.entity.placeable.UmbrellaEntity;
import net.tropicraft.core.common.entity.placeable.WallItemEntity;
import net.tropicraft.core.common.entity.projectile.ExplodingCoconutEntity;
import net.tropicraft.core.common.entity.projectile.LavaBallEntity;
import net.tropicraft.core.common.entity.projectile.PoisonBlotEntity;
import net.tropicraft.core.common.entity.projectile.SpearEntity;
import net.tropicraft.core.common.entity.underdasea.CuberaEntity;
import net.tropicraft.core.common.entity.underdasea.EagleRayEntity;
import net.tropicraft.core.common.entity.underdasea.ManOWarEntity;
import net.tropicraft.core.common.entity.underdasea.ManateeEntity;
import net.tropicraft.core.common.entity.underdasea.MarlinEntity;
import net.tropicraft.core.common.entity.underdasea.PiranhaEntity;
import net.tropicraft.core.common.entity.underdasea.SardineEntity;
import net.tropicraft.core.common.entity.underdasea.SeaUrchinEntity;
import net.tropicraft.core.common.entity.underdasea.SeahorseEntity;
import net.tropicraft.core.common.entity.underdasea.SharkEntity;
import net.tropicraft.core.common.entity.underdasea.StarfishEntity;
import net.tropicraft.core.common.entity.underdasea.TropicraftDolphinEntity;
import net.tropicraft.core.common.entity.underdasea.TropicraftFishUtils;
import net.tropicraft.core.common.entity.underdasea.TropicraftTropicalFishEntity;
import net.tropicraft.core.common.item.TropicraftItems;

@EventBusSubscriber(modid="tropicraft")
public class TropicraftEntities {
    public static final Registrate REGISTRATE = Tropicraft.registrate();
    private static final float EGG_WIDTH = 0.4f;
    private static final float EGG_HEIGHT = 0.5f;
    public static final EntityEntry<EntityKoaHunter> KOA = REGISTRATE.entity("koa", EntityKoaHunter::new, MobCategory.MISC).properties(b -> b.sized(0.6f, 1.95f).setTrackingRange(8).setUpdateInterval(3).fireImmune().setShouldReceiveVelocityUpdates(true)).attributes(EntityKoaBase::createAttributes).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canAnimalSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE).renderer(() -> KoaRenderer::new).register();
    public static final EntityEntry<TropiCreeperEntity> TROPICREEPER = REGISTRATE.entity("tropicreeper", TropiCreeperEntity::new, MobCategory.CREATURE).properties(b -> b.sized(0.6f, 1.7f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).attributes(TropiCreeperEntity::createAttributes).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canAnimalSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE).loot((lootTables, entity) -> lootTables.add(entity, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)TropicraftItems.MUSIC_DISC_EASTERN_ISLES.get()))).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().of(EntityTypeTags.SKELETONS)))))).renderer(() -> TropiCreeperRenderer::new).register();
    public static final EntityEntry<IguanaEntity> IGUANA = REGISTRATE.entity("iguana", IguanaEntity::new, MobCategory.CREATURE).properties(b -> b.sized(1.0f, 0.4f).setTrackingRange(8).setUpdateInterval(3).fireImmune().setShouldReceiveVelocityUpdates(true)).attributes(IguanaEntity::createAttributes).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canAnimalSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE).loot((lootTables, entity) -> TropicraftEntities.dropItemsWithEnchantBonus(lootTables, entity, TropicraftItems.IGUANA_LEATHER, TropicraftItems.SCALE, (NumberProvider)ConstantValue.exactly((float)3.0f))).renderer(() -> IguanaRenderer::new).register();
    public static final EntityEntry<UmbrellaEntity> UMBRELLA = REGISTRATE.entity("umbrella", UmbrellaEntity::new, MobCategory.MISC).properties(b -> b.sized(1.0f, 4.0f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false)).renderer(() -> UmbrellaRenderer::new).register();
    public static final EntityEntry<ChairEntity> CHAIR = REGISTRATE.entity("chair", ChairEntity::new, MobCategory.MISC).properties(b -> b.sized(1.5f, 0.5f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false).passengerAttachments(new Vec3[]{new Vec3(0.0, 0.25, -0.125)})).renderer(() -> ChairRenderer::new).register();
    public static final EntityEntry<BeachFloatEntity> BEACH_FLOAT = REGISTRATE.entity("beach_float", BeachFloatEntity::new, MobCategory.MISC).properties(b -> b.sized(2.0f, 0.175f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false).passengerAttachments(new Vec3[]{new Vec3(0.0, -0.625, -0.6)})).renderer(() -> BeachFloatRenderer::new).register();
    public static final EntityEntry<TropiSkellyEntity> TROPISKELLY = REGISTRATE.entity("tropiskelly", TropiSkellyEntity::new, MobCategory.MONSTER).properties(b -> b.sized(0.7f, 1.95f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(TropiSkellyEntity::createAttributes).loot(TropicraftEntities::noDrops).renderer(() -> TropiSkellyRenderer::new).register();
    public static final EntityEntry<EIHEntity> EIH = REGISTRATE.entity("eih", EIHEntity::new, MobCategory.CREATURE).properties(b -> b.sized(1.2f, 3.25f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canAnimalSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(EIHEntity::createAttributes).loot((lootTables, entity) -> TropicraftEntities.dropItemsWithEnchantBonus(lootTables, entity, (ItemLike)TropicraftBlocks.CHUNK.get(), (NumberProvider)ConstantValue.exactly((float)3.0f))).lang("Easter Island Head").renderer(() -> EIHRenderer::new).register();
    public static final EntityEntry<WallItemEntity> WALL_ITEM = REGISTRATE.entity("wall_item", WallItemEntity::new, MobCategory.MISC).properties(b -> b.sized(0.5f, 0.5f).setTrackingRange(8).setUpdateInterval(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false)).renderer(() -> WallItemRenderer::new).register();
    public static final EntityEntry<BambooItemFrame> BAMBOO_ITEM_FRAME = REGISTRATE.entity("bamboo_item_frame", BambooItemFrame::new, MobCategory.MISC).properties(b -> b.sized(0.5f, 0.5f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false)).renderer(() -> BambooItemFrameRenderer::new).register();
    public static final EntityEntry<LavaBallEntity> LAVA_BALL = null;
    public static final EntityEntry<SeaTurtleEntity> SEA_TURTLE = REGISTRATE.entity("turtle", SeaTurtleEntity::new, MobCategory.WATER_CREATURE).properties(b -> b.sized(0.8f, 0.35f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).passengerAttachments(new Vec3[]{new Vec3(0.0, 0.45625, 0.0)})).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SeaTurtleEntity::canSpawnOnLand, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(Turtle::createAttributes).tag(new TagKey[]{EntityTypeTags.CAN_BREATHE_UNDER_WATER}).tag(new TagKey[]{EntityTypeTags.AQUATIC}).loot((lootTables, entity) -> TropicraftEntities.dropItem(lootTables, entity, TropicraftItems.TURTLE_SHELL)).renderer(() -> SeaTurtleRenderer::new).register();
    public static final EntityEntry<MarlinEntity> MARLIN = REGISTRATE.entity("marlin", MarlinEntity::new, MobCategory.WATER_CREATURE).properties(b -> b.sized(1.4f, 0.95f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canSpawnOceanWaterMob, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(MarlinEntity::createAttributes).tag(new TagKey[]{EntityTypeTags.AXOLOTL_HUNT_TARGETS}).loot((lootTables, entity) -> TropicraftEntities.dropItemsWithEnchantBonus(lootTables, entity, TropicraftItems.FRESH_MARLIN, (NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).renderer(() -> MarlinRenderer::new).register();
    public static final EntityEntry<FailgullEntity> FAILGULL = REGISTRATE.entity("failgull", FailgullEntity::new, MobCategory.AMBIENT).properties(b -> b.sized(0.4f, 0.6f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).eyeHeight(0.3f)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(FailgullEntity::createAttributes).loot(TropicraftEntities::noDrops).renderer(() -> FailgullRenderer::new).register();
    public static final EntityEntry<TropicraftDolphinEntity> DOLPHIN = REGISTRATE.entity("dolphin", TropicraftDolphinEntity::new, MobCategory.WATER_CREATURE).properties(b -> b.sized(1.4f, 0.5f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canSpawnOceanWaterMob, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(Dolphin::createAttributes).loot((lootTables, entity) -> TropicraftEntities.dropItemsWithEnchantBonus(lootTables, entity, TropicraftItems.TROPICAL_FERTILIZER, (NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).renderer(() -> DolphinRenderer::new).register();
    public static final EntityEntry<SeahorseEntity> SEAHORSE = REGISTRATE.entity("seahorse", SeahorseEntity::new, MobCategory.WATER_AMBIENT).properties(b -> b.sized(0.5f, 0.6f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canSpawnOceanWaterMob, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(SeahorseEntity::createAttributes).tag(new TagKey[]{EntityTypeTags.AXOLOTL_HUNT_TARGETS}).loot(TropicraftEntities::noDrops).renderer(() -> SeahorseRenderer::new).register();
    public static final EntityEntry<PoisonBlotEntity> POISON_BLOT = REGISTRATE.entity("poison_blot", PoisonBlotEntity::new, MobCategory.MISC).properties(b -> b.sized(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(20).setShouldReceiveVelocityUpdates(true)).renderer(() -> PoisonBlotRenderer::new).register();
    public static final EntityEntry<TreeFrogEntity> TREE_FROG = REGISTRATE.entity("tree_frog", TreeFrogEntity::new, MobCategory.CREATURE).properties(b -> b.sized(0.6f, 0.4f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canAnimalSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(TreeFrogEntity::createAttributes).loot((lootTables, entity) -> lootTables.add(entity, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().flags(EntityFlagsPredicate.Builder.flags().setIsBaby(Boolean.valueOf(false))).nbt(new NbtPredicate((CompoundTag)Util.make((Object)new CompoundTag(), c -> c.putInt("Type", TreeFrogEntity.Type.GREEN.ordinal())))))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)TropicraftItems.POISON_FROG_SKIN.get())))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)TropicraftItems.FROG_LEG.get())))))).renderer(() -> TreeFrogRenderer::new).register();
    public static final EntityEntry<SeaUrchinEntity> SEA_URCHIN = REGISTRATE.entity("sea_urchin", SeaUrchinEntity::new, MobCategory.WATER_AMBIENT).properties(b -> b.sized(0.5f, 0.5f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canSpawnOceanWaterMob, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(SeaUrchinEntity::createAttributes).tag(new TagKey[]{EntityTypeTags.CAN_BREATHE_UNDER_WATER}).loot((lootTables, entity) -> TropicraftEntities.dropItem(lootTables, entity, TropicraftItems.SEA_URCHIN_ROE)).renderer(() -> SeaUrchinRenderer::new).register();
    public static final EntityEntry<SeaUrchinEggEntity> SEA_URCHIN_EGG_ENTITY = REGISTRATE.entity("sea_urchin_egg", SeaUrchinEggEntity::new, MobCategory.WATER_AMBIENT).properties(b -> b.sized(0.4f, 0.5f).setTrackingRange(6).setUpdateInterval(15).setShouldReceiveVelocityUpdates(false)).attributes(EggEntity::createAttributes).tag(new TagKey[]{EntityTypeTags.CAN_BREATHE_UNDER_WATER}).loot(TropicraftEntities::noDrops).renderer(() -> ClientSetup::seaUrchinEggRenderer).register();
    public static final EntityEntry<StarfishEntity> STARFISH = REGISTRATE.entity("starfish", StarfishEntity::new, MobCategory.WATER_AMBIENT).properties(b -> b.sized(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(15).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canSpawnOceanWaterMob, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(StarfishEntity::createAttributes).tag(new TagKey[]{EntityTypeTags.AXOLOTL_HUNT_TARGETS}).tag(new TagKey[]{EntityTypeTags.CAN_BREATHE_UNDER_WATER}).loot((lootTables, entity) -> TropicraftEntities.dropItem(lootTables, entity, TropicraftItems.STARFISH)).renderer(() -> StarfishRenderer::new).register();
    public static final EntityEntry<StarfishEggEntity> STARFISH_EGG = REGISTRATE.entity("starfish_egg", StarfishEggEntity::new, MobCategory.WATER_AMBIENT).properties(b -> b.sized(0.4f, 0.5f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false)).attributes(EggEntity::createAttributes).loot(TropicraftEntities::noDrops).tag(new TagKey[]{EntityTypeTags.CAN_BREATHE_UNDER_WATER}).renderer(() -> ClientSetup::starfishEggRenderer).register();
    public static final EntityEntry<VMonkeyEntity> V_MONKEY = REGISTRATE.entity("v_monkey", VMonkeyEntity::new, MobCategory.CREATURE).properties(b -> b.sized(0.8f, 0.8f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canAnimalSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(VMonkeyEntity::createAttributes).loot(TropicraftEntities::noDrops).lang("Vervet Monkey").renderer(() -> VMonkeyRenderer::new).register();
    public static final EntityEntry<SardineEntity> RIVER_SARDINE = REGISTRATE.entity("sardine", SardineEntity::new, MobCategory.WATER_AMBIENT).properties(b -> b.sized(0.3f, 0.4f).setTrackingRange(4).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftFishUtils::checkSurfaceWaterAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(SardineEntity::createAttributes).loot((lootTables, entity) -> TropicraftEntities.dropItem(lootTables, entity, TropicraftItems.RAW_FISH)).renderer(() -> SardineRenderer::new).register();
    public static final EntityEntry<PiranhaEntity> PIRANHA = REGISTRATE.entity("piranha", PiranhaEntity::new, MobCategory.WATER_CREATURE).properties(b -> b.sized(0.3f, 0.4f).setTrackingRange(4).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftFishUtils::checkSurfaceWaterAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(PiranhaEntity::createAttributes).tag(new TagKey[]{EntityTypeTags.AXOLOTL_HUNT_TARGETS}).loot((lootTables, entity) -> TropicraftEntities.dropItem(lootTables, entity, TropicraftItems.RAW_FISH)).renderer(() -> PiranhaRenderer::new).register();
    public static final EntityEntry<TropicraftTropicalFishEntity> TROPICAL_FISH = REGISTRATE.entity("tropical_fish", TropicraftTropicalFishEntity::new, MobCategory.WATER_AMBIENT).properties(b -> b.sized(0.3f, 0.4f).setTrackingRange(4).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftFishUtils::checkSurfaceWaterAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(TropicraftTropicalFishEntity::createAttributes).tag(new TagKey[]{EntityTypeTags.AXOLOTL_HUNT_TARGETS}).loot((lootTables, entity) -> TropicraftEntities.dropItem(lootTables, entity, TropicraftItems.RAW_FISH)).renderer(() -> TropicraftTropicalFishRenderer::new).register();
    public static final EntityEntry<EagleRayEntity> EAGLE_RAY = REGISTRATE.entity("eagle_ray", EagleRayEntity::new, MobCategory.WATER_CREATURE).properties(b -> b.sized(2.0f, 0.4f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canSpawnOceanWaterMob, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(EagleRayEntity::createAttributes).loot((lootTables, entity) -> TropicraftEntities.dropItem(lootTables, entity, TropicraftItems.RAW_RAY)).lang("Spotted Eagle Ray").renderer(() -> EagleRayRenderer::new).register();
    public static final EntityEntry<TropiSpiderEntity> TROPI_SPIDER = REGISTRATE.entity("tropi_spider", TropiSpiderEntity::new, MobCategory.MONSTER).properties(b -> b.sized(1.4f, 0.9f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(Spider::createAttributes).loot(TropicraftEntities::noDrops).renderer(() -> TropiSpiderRenderer::new).register();
    public static final EntityEntry<TropiSpiderEggEntity> TROPI_SPIDER_EGG = REGISTRATE.entity("tropi_spider_egg", TropiSpiderEggEntity::new, MobCategory.MONSTER).properties(b -> b.sized(0.4f, 0.5f).setTrackingRange(6).setUpdateInterval(10).setShouldReceiveVelocityUpdates(false)).attributes(EggEntity::createAttributes).loot(TropicraftEntities::noDrops).lang("Tropics Spider Egg").renderer(() -> ClientSetup::tropiSpiderEggRenderer).register();
    public static final EntityEntry<AshenMaskEntity> ASHEN_MASK = REGISTRATE.entity("ashen_mask", AshenMaskEntity::new, MobCategory.MISC).properties(b -> b.sized(0.8f, 0.2f).setTrackingRange(6).setUpdateInterval(100).setShouldReceiveVelocityUpdates(true)).renderer(() -> AshenMaskRenderer::new).register();
    public static final EntityEntry<AshenEntity> ASHEN = REGISTRATE.entity("ashen", AshenEntity::new, MobCategory.MONSTER).properties(b -> b.sized(0.5f, 1.3f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(AshenEntity::createAttributes).loot(TropicraftEntities::noDrops).renderer(() -> AshenRenderer::new).register();
    public static final EntityEntry<ExplodingCoconutEntity> EXPLODING_COCONUT = REGISTRATE.entity("exploding_coconut", ExplodingCoconutEntity::new, MobCategory.MISC).properties(b -> b.sized(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(10).setShouldReceiveVelocityUpdates(true)).renderer(() -> ThrownItemRenderer::new).register();
    public static final EntityEntry<SharkEntity> HAMMERHEAD = REGISTRATE.entity("hammerhead", SharkEntity::new, MobCategory.WATER_CREATURE).properties(b -> b.sized(2.4f, 1.4f).setTrackingRange(5).setUpdateInterval(2).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canSpawnOceanWaterMob, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(SharkEntity::createAttributes).loot((lootTables, entity) -> TropicraftEntities.dropItemsWithEnchantBonus(lootTables, entity, TropicraftItems.TROPICAL_FERTILIZER, (NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).renderer(() -> SharkRenderer::new).register();
    public static final EntityEntry<SeaTurtleEggEntity> SEA_TURTLE_EGG = REGISTRATE.entity("turtle_egg", SeaTurtleEggEntity::new, MobCategory.MONSTER).properties(b -> b.sized(0.4f, 0.5f).setTrackingRange(6).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false)).attributes(EggEntity::createAttributes).loot(TropicraftEntities::noDrops).lang("Sea Turtle Egg").renderer(() -> ClientSetup::seaTurtleEggRenderer).register();
    public static final EntityEntry<TropiBeeEntity> TROPI_BEE = REGISTRATE.entity("tropibee", TropiBeeEntity::new, MobCategory.CREATURE).properties(b -> b.sized(0.4f, 0.6f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(Bee::createAttributes).tag(new TagKey[]{EntityTypeTags.BEEHIVE_INHABITORS}).loot((lootTables, entity) -> TropicraftEntities.dropItemsWithEnchantBonus(lootTables, entity, (ItemLike)TropicraftItems.COOL_SHADES.get(), (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).renderer(() -> TropiBeeRenderer::new).register();
    public static final EntityEntry<CowktailEntity> COWKTAIL = REGISTRATE.entity("cowktail", CowktailEntity::new, MobCategory.CREATURE).properties(b -> b.sized(0.9f, 1.4f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canAnimalSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(Cow::createAttributes).loot(TropicraftEntities::noDrops).renderer(() -> CowktailRenderer::new).register();
    public static final EntityEntry<ManOWarEntity> MAN_O_WAR = REGISTRATE.entity("man_o_war", ManOWarEntity::new, MobCategory.WATER_AMBIENT).properties(b -> b.sized(0.6f, 0.8f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).eyeHeight(0.4f)).spawnPlacement(SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canSpawnSurfaceOceanWaterMob, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(ManOWarEntity::createAttributes).loot((lootTables, entity) -> TropicraftEntities.dropItemsWithEnchantBonus(lootTables, entity, (ItemLike)Items.SLIME_BALL, (NumberProvider)UniformGenerator.between((float)3.0f, (float)4.0f))).lang("Man o' War").tag(new TagKey[]{EntityTypeTags.CAN_BREATHE_UNDER_WATER}).renderer(() -> ManOWarRenderer::new).register();
    public static final EntityEntry<TapirEntity> TAPIR = REGISTRATE.entity("tapir", TapirEntity::new, MobCategory.CREATURE).properties(b -> b.sized(0.8f, 1.0f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canAnimalSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(TapirEntity::createAttributes).loot(TropicraftEntities::noDrops).renderer(() -> TapirRenderer::new).register();
    public static final EntityEntry<JaguarEntity> JAGUAR = REGISTRATE.entity("jaguar", JaguarEntity::new, MobCategory.CREATURE).properties(b -> b.sized(0.9f, 1.0f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canAnimalSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(JaguarEntity::createAttributes).loot(TropicraftEntities::noDrops).renderer(() -> JaguarRenderer::new).register();
    public static final EntityEntry<BasiliskLizardEntity> BROWN_BASILISK_LIZARD = REGISTRATE.entity("brown_basilisk_lizard", BasiliskLizardEntity::new, MobCategory.CREATURE).properties(b -> b.sized(0.7f, 0.4f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canAnimalSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(BasiliskLizardEntity::createAttributes).loot(TropicraftEntities::noDrops).renderer(() -> BasiliskLizardRenderer::brown).register();
    public static final EntityEntry<BasiliskLizardEntity> GREEN_BASILISK_LIZARD = REGISTRATE.entity("green_basilisk_lizard", BasiliskLizardEntity::new, MobCategory.CREATURE).properties(b -> b.sized(0.7f, 0.4f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canAnimalSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(BasiliskLizardEntity::createAttributes).loot(TropicraftEntities::noDrops).renderer(() -> BasiliskLizardRenderer::green).register();
    public static final EntityEntry<HummingbirdEntity> HUMMINGBIRD = REGISTRATE.entity("hummingbird", HummingbirdEntity::new, MobCategory.CREATURE).properties(b -> b.sized(0.5f, 0.5f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HummingbirdEntity::canHummingbirdSpawnOn, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(HummingbirdEntity::createAttributes).loot(TropicraftEntities::noDrops).renderer(() -> HummingbirdRenderer::new).register();
    public static final EntityEntry<FiddlerCrabEntity> FIDDLER_CRAB = REGISTRATE.entity("fiddler_crab", FiddlerCrabEntity::new, MobCategory.CREATURE).properties(b -> b.sized(0.5f, 0.2f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FiddlerCrabEntity::canCrabSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(FiddlerCrabEntity::createAttributes).tag(new TagKey[]{EntityTypeTags.CAN_BREATHE_UNDER_WATER}).loot(TropicraftEntities::noDrops).renderer(() -> FiddlerCrabRenderer::new).register();
    public static final EntityEntry<SpiderMonkeyEntity> SPIDER_MONKEY = REGISTRATE.entity("spider_monkey", SpiderMonkeyEntity::new, MobCategory.CREATURE).properties(b -> b.sized(0.5f, 0.6f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canAnimalSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(SpiderMonkeyEntity::createAttributes).loot(TropicraftEntities::noDrops).renderer(() -> SpiderMonkeyRenderer::new).register();
    public static final EntityEntry<WhiteLippedPeccaryEntity> WHITE_LIPPED_PECCARY = REGISTRATE.entity("white_lipped_peccary", WhiteLippedPeccaryEntity::new, MobCategory.CREATURE).properties(b -> b.sized(0.7f, 0.8f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canAnimalSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(WhiteLippedPeccaryEntity::createAttributes).loot(TropicraftEntities::noDrops).renderer(() -> WhiteLippedPeccaryRenderer::new).register();
    public static final EntityEntry<CuberaEntity> CUBERA = REGISTRATE.entity("cubera", CuberaEntity::new, MobCategory.WATER_CREATURE).properties(b -> b.sized(1.2f, 0.8f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canSpawnOceanWaterMob, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(CuberaEntity::createAttributes).loot((lootTables, entity) -> TropicraftEntities.dropItem(lootTables, entity, TropicraftItems.RAW_FISH)).renderer(() -> CuberaRenderer::new).register();
    public static final EntityEntry<FishingBobberEntity> FISHING_BOBBER = REGISTRATE.entity("fishing_bobber", FishingBobberEntity::new, MobCategory.MISC).properties(b -> b.sized(1.2f, 0.8f).setTrackingRange(128).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).attributes(FishingBobberEntity::createAttributes).renderer(() -> FishingBobberEntityRenderer::new).register();
    public static final EntityEntry<SpearEntity> SPEAR = REGISTRATE.entity("spear", SpearEntity::new, MobCategory.MISC).properties(b -> b.sized(0.8f, 0.8f).setTrackingRange(4).updateInterval(20).setShouldReceiveVelocityUpdates(true)).renderer(() -> SpearRenderer::new).register();
    public static final RegistryEntry<EntityType<?>, EntityType<GibnutEntity>> GIBNUT = REGISTRATE.entity("gibnut", GibnutEntity::new, MobCategory.MONSTER).properties(b -> b.sized(0.7f, 0.3f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canAnimalSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(GibnutEntity::createAttributes).loot(TropicraftEntities::noDrops).renderer(() -> GibnutRenderer::new).register();
    public static final RegistryEntry<EntityType<?>, EntityType<ManateeEntity>> MANATEE = REGISTRATE.entity("manatee", ManateeEntity::new, MobCategory.WATER_CREATURE).properties(b -> b.sized(2.0f, 1.3f).setTrackingRange(5).setUpdateInterval(2).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canSpawnOceanWaterMob, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(ManateeEntity::createAttributes).loot(TropicraftEntities::noDrops).renderer(() -> ManateeRenderer::new).register();
    public static final RegistryEntry<EntityType<?>, EntityType<SlenderHarvestMouseEntity>> SLENDER_HARVEST_MOUSE = REGISTRATE.entity("slender_harvest_mouse", SlenderHarvestMouseEntity::new, MobCategory.MONSTER).properties(b -> b.sized(0.5f, 0.2f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canAnimalSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(SlenderHarvestMouseEntity::createAttributes).loot(TropicraftEntities::noDrops).renderer(() -> SlenderHarvestMouseRenderer::new).register();
    public static final RegistryEntry<EntityType<?>, EntityType<ToucanEntity>> TOUCAN = REGISTRATE.entity("toucan", ToucanEntity::new, MobCategory.MONSTER).properties(b -> b.sized(0.5f, 0.5f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ToucanEntity::canToucanSpawnOn, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(ToucanEntity::createAttributes).loot(TropicraftEntities::noDrops).renderer(() -> ToucanRenderer::new).tag(new TagKey[]{EntityTypeTags.FALL_DAMAGE_IMMUNE}).tag(new TagKey[]{TropicraftTags.Entities.CAN_STAND_ON_BRANCH}).register();
    public static final RegistryEntry<EntityType<?>, EntityType<SmallBirdEntity>> PAPYRUS_CANARY = TropicraftEntities.smallBird("papyrus_canary").renderer(() -> PapyrusCanaryRenderer::new).register();
    public static final RegistryEntry<EntityType<?>, EntityType<SmallBirdEntity>> PAPYRUS_GONOLEK = TropicraftEntities.smallBird("papyrus_gonolek").renderer(() -> PapyrusGonolekRenderer::new).register();
    public static final RegistryEntry<EntityType<?>, EntityType<SmallBirdEntity>> WHITE_COLLARED_OLIVEBACK = TropicraftEntities.smallBird("white_collared_oliveback").renderer(() -> WhiteCollaredOlivebackRenderer::new).register();
    public static final RegistryEntry<EntityType<?>, EntityType<SmallBirdEntity>> WHITE_WINGED_WARBLER = TropicraftEntities.smallBird("white_winged_warbler").renderer(() -> WhiteWingedWarblerRenderer::new).register();
    public static final RegistryEntry<EntityType<?>, EntityType<ShoebillStorkEntity>> SHOEBILL_STORK = REGISTRATE.entity("shoebill_stork", ShoebillStorkEntity::new, MobCategory.CREATURE).properties(b -> b.sized(0.6f, 1.5f).setTrackingRange(8).setUpdateInterval(3)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TropicraftEntities::canAnimalSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(ShoebillStorkEntity::createAttributes).loot(TropicraftEntities::noDrops).tag(new TagKey[]{EntityTypeTags.FALL_DAMAGE_IMMUNE}).renderer(() -> ShoebillStorkRenderer::new).register();

    private static EntityBuilder<SmallBirdEntity, Registrate> smallBird(String name) {
        return REGISTRATE.entity(name, SmallBirdEntity::new, MobCategory.CREATURE).properties(b -> b.sized(0.3f, 0.3f).setTrackingRange(5).setUpdateInterval(3)).spawnPlacement(SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SmallBirdEntity::canSmallBirdSpawnOn, RegisterSpawnPlacementsEvent.Operation.REPLACE).attributes(SmallBirdEntity::createAttributes).loot(TropicraftEntities::noDrops).tag(new TagKey[]{EntityTypeTags.FALL_DAMAGE_IMMUNE}).tag(new TagKey[]{TropicraftTags.Entities.CAN_STAND_ON_BRANCH});
    }

    public static boolean canAnimalSpawn(EntityType<? extends Mob> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        BlockState groundState = worldIn.getBlockState(pos.below());
        return groundState.is(Blocks.GRASS_BLOCK) || groundState.is(BlockTags.SAND) || groundState.is(TropicraftTags.Blocks.MUD);
    }

    public static <T extends Mob> boolean canSpawnOceanWaterMob(EntityType<T> waterMob, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource rand) {
        int seaLevel = TropicraftDimension.getSeaLevel((LevelReader)world);
        return pos.getY() > 90 && pos.getY() < seaLevel && world.getFluidState(pos).is(FluidTags.WATER);
    }

    public static <T extends Mob> boolean canSpawnSurfaceOceanWaterMob(EntityType<T> waterMob, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource rand) {
        int seaLevel = TropicraftDimension.getSeaLevel((LevelReader)world);
        return pos.getY() > seaLevel - 3 && pos.getY() < seaLevel && world.getFluidState(pos).is(FluidTags.WATER);
    }

    private static void noDrops(RegistrateEntityLootTables loot, EntityType<?> type) {
        loot.add(type, LootTable.lootTable());
    }

    private static <T extends LivingEntity> void dropItemsWithEnchantBonus(RegistrateEntityLootTables lootTables, EntityType<T> entity, RegistryEntry<Item, ? extends Item> loot, RegistryEntry<Item, Item> multiLoot, NumberProvider range) {
        lootTables.add(entity, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)loot.get())))).withPool(LootPool.lootPool().setRolls(range).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)multiLoot.get())).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)lootTables.getRegistries(), (NumberProvider)UniformGenerator.between((float)0.0f, (float)0.33333334f))))));
    }

    private static <T extends LivingEntity> void dropItem(RegistrateEntityLootTables lootTables, EntityType<T> entity, RegistryEntry<? extends ItemLike, ? extends ItemLike> loot) {
        lootTables.add(entity, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)loot.get())))));
    }

    private static <T extends LivingEntity> void dropItemsWithEnchantBonus(RegistrateEntityLootTables lootTables, EntityType<T> entity, RegistryEntry<? extends ItemLike, ? extends ItemLike> loot, NumberProvider range) {
        TropicraftEntities.dropItemsWithEnchantBonus(lootTables, entity, (ItemLike)loot.get(), range);
    }

    private static <T extends LivingEntity> void dropItemsWithEnchantBonus(RegistrateEntityLootTables lootTables, EntityType<T> entity, ItemLike loot, NumberProvider range) {
        lootTables.add(entity, LootTable.lootTable().withPool(LootPool.lootPool().setRolls(range).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)loot).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)lootTables.getRegistries(), (NumberProvider)UniformGenerator.between((float)0.0f, (float)0.33333334f))))));
    }

    @SubscribeEvent
    public static void onMobSpawn(MobSpawnEvent.PositionCheck event) {
        Mob mob;
        ServerLevel level = event.getLevel().getLevel();
        if (!(level.dimension() != TropicraftDimension.WORLD || ((Boolean)TropicsConfigs.COMMON.spawnHostileMobsInTropics.get()).booleanValue() || event.getSpawnType() != MobSpawnType.NATURAL && event.getSpawnType() != MobSpawnType.CHUNK_GENERATION || (mob = event.getEntity()).getType() == ASHEN.get() || mob.getType().getCategory() != MobCategory.MONSTER && !(mob instanceof Enemy))) {
            event.setResult(MobSpawnEvent.PositionCheck.Result.FAIL);
        }
    }
}

