/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;
import net.tropicraft.core.common.item.TropicraftItems;

public class EntityAIChillAtFire
extends Goal {
    private final EntityKoaBase entityObj;
    private final int walkingTimeoutMax = 200;
    private int walkingTimeout;
    private int repathPentalty = 0;
    private int lookUpdateTimer = 0;
    private int randXPos = 0;
    private int randYPos = 0;
    private int randZPos = 0;

    public EntityAIChillAtFire(EntityKoaBase entityObjIn) {
        this.entityObj = entityObjIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if ((this.entityObj.getWantsToParty() || this.entityObj.druggedTime > 0) && !this.entityObj.listPosDrums.isEmpty()) {
            return false;
        }
        BlockPos blockpos = this.entityObj.blockPosition();
        if (!this.entityObj.level().isDay() || this.entityObj.level().isRaining() && ((Biome)this.entityObj.level().getBiome(blockpos).value()).getPrecipitationAt(blockpos) != Biome.Precipitation.RAIN) {
            if (!this.isTooClose()) {
                return this.entityObj.level().random.nextInt(20) == 0;
            }
            return false;
        }
        return false;
    }

    public boolean canContinueToUse() {
        if ((this.entityObj.getWantsToParty() || this.entityObj.druggedTime > 0) && !this.entityObj.listPosDrums.isEmpty()) {
            return false;
        }
        BlockPos blockpos = this.entityObj.blockPosition();
        if (!this.entityObj.level().isDay() || this.entityObj.level().isRaining() && ((Biome)this.entityObj.level().getBiome(blockpos).value()).getPrecipitationAt(blockpos) != Biome.Precipitation.RAIN) {
            return !this.isTooClose();
        }
        return this.entityObj.level().random.nextInt(60) != 0;
    }

    public void tick() {
        super.tick();
        boolean isClose = false;
        BlockPos blockposGoal = null;
        blockposGoal = this.entityObj.posLastFireplaceFound != null ? this.entityObj.posLastFireplaceFound.offset(0, -1, 0) : this.entityObj.getRestrictCenter();
        if (blockposGoal.equals((Object)BlockPos.ZERO)) {
            this.stop();
            return;
        }
        double dist = this.entityObj.position().distanceTo(new Vec3((double)blockposGoal.getX(), (double)blockposGoal.getY(), (double)blockposGoal.getZ()));
        if (dist < 4.0 && this.entityObj.onGround()) {
            this.entityObj.setSitting(true);
            this.entityObj.getNavigation().stop();
            isClose = true;
            if (this.lookUpdateTimer <= 0) {
                this.lookUpdateTimer = 200 + this.entityObj.level().random.nextInt(100);
                int range = 2;
                this.randXPos = this.entityObj.level().random.nextInt(range) - this.entityObj.level().random.nextInt(range);
                this.randYPos = this.entityObj.level().random.nextInt(3) == 0 ? 5 + this.entityObj.level().random.nextInt(5) : 0;
                this.randZPos = this.entityObj.level().random.nextInt(range) - this.entityObj.level().random.nextInt(range);
                if (this.entityObj.getId() % 3 == 0) {
                    this.entityObj.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TropicraftItems.BAMBOO_MUG.get()));
                } else if (this.entityObj.getId() % 5 == 0) {
                    this.entityObj.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TropicraftItems.COOKED_FROG_LEG.get()));
                } else {
                    this.entityObj.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TropicraftItems.ORANGE.get()));
                }
                this.entityObj.heal(1.0f);
            }
            this.entityObj.getLookControl().setLookAt((double)(blockposGoal.getX() + this.randXPos), (double)(blockposGoal.getY() + this.randYPos) + 1.0, (double)(blockposGoal.getZ() + this.randZPos), 8.0f, 8.0f);
        } else {
            this.entityObj.setSitting(false);
        }
        if (!isClose) {
            if ((this.entityObj.getNavigation().isDone() || this.walkingTimeout <= 0) && this.repathPentalty <= 0) {
                Vec3 Vector3d;
                int i = blockposGoal.getX();
                int j = blockposGoal.getY();
                int k = blockposGoal.getZ();
                boolean success = false;
                success = this.entityObj.distanceToSqr(Vec3.atCenterOf((Vec3i)blockposGoal)) > 256.0 ? ((Vector3d = DefaultRandomPos.getPosTowards((PathfinderMob)this.entityObj, (int)14, (int)3, (Vec3)new Vec3((double)i + 0.5, (double)j, (double)k + 0.5), (double)1.5707963705062866)) != null ? this.entityObj.getNavigation().moveTo(Vector3d.x, Vector3d.y, Vector3d.z, 1.0) : Util.tryMoveToXYZLongDist((Mob)this.entityObj, new BlockPos(i, j, k), 1.0)) : this.entityObj.getNavigation().moveTo((double)i + 0.5, (double)j, (double)k + 0.5, 1.0);
                if (!success) {
                    this.repathPentalty = 40;
                } else {
                    this.walkingTimeout = 200;
                }
            } else if (this.walkingTimeout > 0) {
                --this.walkingTimeout;
            }
        }
        if (this.repathPentalty > 0) {
            --this.repathPentalty;
        }
        if (this.lookUpdateTimer > 0) {
            --this.lookUpdateTimer;
        }
    }

    public void start() {
        super.start();
        this.entityObj.getNavigation().stop();
    }

    public void stop() {
        super.stop();
        this.entityObj.setSitting(false);
        this.walkingTimeout = 0;
    }

    public boolean isTooClose() {
        BlockPos blockposGoal = null;
        blockposGoal = this.entityObj.posLastFireplaceFound != null ? this.entityObj.posLastFireplaceFound.offset(0, -1, 0) : this.entityObj.getRestrictCenter();
        if (blockposGoal.equals((Object)BlockPos.ZERO)) {
            return false;
        }
        double dist = this.entityObj.position().distanceTo(new Vec3((double)blockposGoal.getX(), (double)blockposGoal.getY(), (double)blockposGoal.getZ()));
        return dist <= 3.0;
    }
}

