/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;
import net.tropicraft.core.common.entity.passive.FishingBobberEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class EntityAIGoneFishin
extends Goal {
    private FISHING_STATE state = FISHING_STATE.IDLE;
    private boolean debugTask = false;
    private final EntityKoaBase entity;
    private final RandomSource rand;
    @Nullable
    private BlockPos posLastWaterFound;
    @Nullable
    private BlockPos posLastLandFound;
    private final int walkingTimeoutMax = 600;
    private final int fishingTimeoutMax = 600;
    private int walkingTimeout;
    private int fishingTimeout;
    private final float moveSpeedAmp = 1.0f;
    private int fishCaught = 0;
    private int repathPenalty = 0;
    private final int repathPenaltyMax = 60;
    private int repathAttempts = 0;
    public final long timeBetweenFishing = 1200L;
    public final long timeBetweenFishingRandom = 30L;
    public final List<ItemStack> listFishables = new ArrayList<ItemStack>();

    public EntityAIGoneFishin(EntityKoaBase entity) {
        this.entity = entity;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.rand = RandomSource.create();
        this.walkingTimeout = 600;
        this.fishingTimeout = 600;
        this.listFishables.add(new ItemStack((ItemLike)Items.TROPICAL_FISH));
        this.listFishables.add(new ItemStack((ItemLike)TropicraftItems.FRESH_MARLIN.get()));
        this.listFishables.add(new ItemStack((ItemLike)TropicraftItems.TROPICAL_FERTILIZER.get()));
        this.listFishables.add(new ItemStack((ItemLike)TropicraftItems.RAW_RAY.get()));
    }

    public void start() {
        this.entity.setFishingItem();
    }

    public boolean canUse() {
        this.entity.lastTimeFished = 0L;
        this.debugTask = false;
        BlockPos blockpos = this.entity.blockPosition();
        if (!this.entity.level().isDay() || this.entity.level().isRaining() && ((Biome)this.entity.level().getBiome(blockpos).value()).getPrecipitationAt(blockpos) == Biome.Precipitation.RAIN) {
            return false;
        }
        boolean result = false;
        if (this.entity.lastTimeFished < this.entity.level().getGameTime() && this.entity.level().random.nextInt(3) == 0) {
            BlockPos posWater = this.findWater();
            if (posWater == null) {
                posWater = Util.findBlock((Mob)this.entity, 5, Util::isDeepWater);
            }
            if (posWater != null) {
                if (Util.tryMoveToXYZLongDist((Mob)this.entity, posWater, 1.0)) {
                    this.posLastWaterFound = posWater;
                    result = true;
                    this.entity.lastTimeFished = this.entity.level().getGameTime() + 1200L + 30L;
                    this.setState(FISHING_STATE.WALKING_TO_WATER);
                    this.debug("found water, start executing");
                } else {
                    this.debug("failed the path, skip executing");
                }
            } else {
                this.debug("couldnt find water, skip executing");
            }
        }
        return result;
    }

    public boolean canContinueToUse() {
        return this.posLastWaterFound != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void tick() {
        super.tick();
        if (this.repathPenalty > 0) {
            --this.repathPenalty;
        }
        if (this.state == FISHING_STATE.IDLE) {
            if (this.posLastWaterFound == null) {
                this.posLastWaterFound = this.findWater();
            }
            if (this.posLastWaterFound == null) {
                if (this.rand.nextInt(150) != 0) return;
                if (!this.entity.getNavigation().isDone()) return;
                return;
            }
            if (Util.tryMoveToXYZLongDist((Mob)this.entity, this.posLastWaterFound, 1.0)) {
                this.setState(FISHING_STATE.WALKING_TO_WATER);
                return;
            }
            this.debug("found water but pathing failed, abort");
            this.stop();
            return;
        }
        if (this.state == FISHING_STATE.WALKING_TO_WATER) {
            if (this.posLastWaterFound == null) {
                this.setState(FISHING_STATE.IDLE);
                return;
            }
            if (!this.entity.isInWater()) {
                if (this.walkingTimeout <= 0 || this.entity.getNavigation().isDone()) {
                    if (this.walkingTimeout <= 0) {
                        this.debug("water pathing taking too long");
                    } else if (this.entity.getNavigation().isDone()) {
                        this.debug("water pathing having no path, pf find failed?");
                    }
                    if (!Util.tryMoveToXYZLongDist((Mob)this.entity, this.posLastWaterFound, 1.0)) {
                        this.stop();
                        return;
                    }
                    this.debug("found new path to try");
                }
            } else {
                BlockPos posLand = this.findLand();
                if (posLand != null) {
                    this.posLastLandFound = posLand;
                    if (!Util.tryMoveToXYZLongDist((Mob)this.entity, posLand, 1.0)) {
                        this.stop();
                        return;
                    }
                    this.setState(FISHING_STATE.WALKING_TO_LAND);
                }
            }
            if (Util.getDistance((Entity)this.entity, this.posLastWaterFound.getX(), this.posLastWaterFound.getY(), this.posLastWaterFound.getZ()) < 8.0 || this.entity.isInWater()) {
                this.entity.getNavigation().stop();
                this.setState(FISHING_STATE.FISHING);
                this.faceCoord(this.posLastWaterFound, 180.0f, 180.0f);
                this.castLine();
            }
            if (this.walkingTimeout <= 0) return;
            --this.walkingTimeout;
            return;
        }
        BlockPos homePosition = this.entity.getRestrictCenter();
        if (this.state == FISHING_STATE.FISHING) {
            BlockPos posLand;
            if (this.entity.isInWater() && (posLand = this.findLand()) != null) {
                this.posLastLandFound = posLand;
                if (!Util.tryMoveToXYZLongDist((Mob)this.entity, posLand, 1.0)) {
                    this.stop();
                    return;
                }
                this.setState(FISHING_STATE.WALKING_TO_LAND);
            }
            if (this.entity.getLure() != null && (this.entity.getLure().onGround() || this.entity.getLure().caughtEntity != null)) {
                this.stop();
            }
            if (!this.ifCaughtFish()) {
                --this.fishingTimeout;
                return;
            }
            this.retractLine();
            ++this.fishCaught;
            this.entity.inventory.addItem(this.listFishables.get(this.rand.nextInt(this.listFishables.size())));
            this.debug("caught a fish");
            if (this.getFishCount() > 4 || this.rand.nextInt(1) == 0 && this.getFishCount() >= 2) {
                if (Util.tryMoveToXYZLongDist((Mob)this.entity, homePosition, 1.0)) {
                    this.setState(FISHING_STATE.RETURN_TO_BASE);
                    return;
                }
                this.stop();
                return;
            }
            if (this.rand.nextInt(2) == 0) {
                this.setState(FISHING_STATE.IDLE);
                return;
            }
            if (this.posLastWaterFound == null) {
                this.setState(FISHING_STATE.IDLE);
                return;
            }
            this.faceCoord(this.posLastWaterFound, 180.0f, 180.0f);
            this.castLine();
            return;
        }
        if (this.state == FISHING_STATE.RETURN_TO_BASE) {
            if (homePosition.equals((Object)BlockPos.ZERO)) {
                this.stop();
            }
            if (Util.getDistance((Entity)this.entity, homePosition.getX(), homePosition.getY(), homePosition.getZ()) < 3.0) {
                this.debug("dropping off fish, reset");
                this.fishCaught = 0;
                this.entity.tryDumpInventoryIntoHomeChest();
                this.stop();
            }
            if ((this.walkingTimeout <= 0 || this.entity.getNavigation().isDone() && this.entity.level().getGameTime() % 20L == 0L) && !this.retryPathOrAbort(homePosition)) {
                return;
            }
            if (this.walkingTimeout <= 0) return;
            --this.walkingTimeout;
            return;
        }
        if (this.state != FISHING_STATE.WALKING_TO_LAND) return;
        if (Util.getDistance((Entity)this.entity, this.posLastLandFound.getX(), this.posLastLandFound.getY(), this.posLastLandFound.getZ()) < 5.0 || this.entity.onGround()) {
            this.posLastLandFound = new BlockPos((Vec3i)this.entity.blockPosition());
            this.entity.getNavigation().stop();
            this.setState(FISHING_STATE.FISHING);
            this.faceCoord(this.posLastWaterFound, 180.0f, 180.0f);
            this.castLine();
            return;
        }
        if (this.walkingTimeout <= 0 || this.entity.getNavigation().isDone()) {
            if (this.walkingTimeout <= 0) {
                this.debug("pathing taking too long");
            } else if (this.entity.getNavigation().isDone()) {
                this.debug("pathing having no path, pf find failed?");
            }
            if (Util.getDistance((Entity)this.entity, this.posLastLandFound.getX(), this.posLastLandFound.getY(), this.posLastLandFound.getZ()) < 64.0 ? !this.retryPathOrAbort(this.posLastLandFound) : !this.retryPathOrAbort(this.posLastWaterFound)) {
                return;
            }
        }
        if (this.walkingTimeout <= 0) return;
        --this.walkingTimeout;
    }

    private void setState(FISHING_STATE state) {
        this.debug("setting state from " + String.valueOf((Object)this.state) + " to " + String.valueOf((Object)state) + " - " + String.valueOf(this.entity.blockPosition()));
        if (state != FISHING_STATE.FISHING) {
            this.retractLine();
        }
        this.state = state;
        if (this.state == FISHING_STATE.FISHING) {
            this.fishingTimeout = 600;
        } else if (this.state == FISHING_STATE.WALKING_TO_LAND || this.state == FISHING_STATE.WALKING_TO_WATER || this.state == FISHING_STATE.RETURN_TO_BASE) {
            this.walkingTimeout = 600;
        }
    }

    public void stop() {
        super.stop();
        this.debug("reset task");
        this.fishCaught = 0;
        this.posLastLandFound = null;
        this.posLastWaterFound = null;
        this.repathAttempts = 0;
        this.retractLine();
        this.state = FISHING_STATE.IDLE;
    }

    private void maintainPathToBlock(BlockPos pos) {
        if (this.repathPenalty <= 0) {
            this.walkingTimeout = 600;
            boolean success = Util.tryMoveToXYZLongDist((Mob)this.entity, pos, 1.0);
            if (!success) {
                this.debug("repathing failed - " + this.entity.getId() + " - " + String.valueOf((Object)this.state) + " - " + String.valueOf(pos));
                this.repathPenalty = 60;
            }
        }
    }

    private boolean retryPathOrAbort(BlockPos pos) {
        boolean success = Util.tryMoveToXYZLongDist((Mob)this.entity, pos, 1.0);
        if (!success) {
            this.debug("repathing failed, resetting - " + this.entity.getId() + " - " + String.valueOf((Object)this.state) + " - " + String.valueOf(pos));
            this.stop();
        } else {
            this.debug("repathing success - " + this.entity.getId() + " - " + String.valueOf((Object)this.state) + " - " + String.valueOf(pos));
            this.walkingTimeout = 600;
        }
        return success;
    }

    private void debug(String str) {
        if (this.debugTask) {
            System.out.println(str);
        }
    }

    @Nullable
    private BlockPos findWater() {
        return Util.findBlock((Mob)this.entity, 60, Util::isDeepWater);
    }

    @Nullable
    private BlockPos findLand() {
        return Util.findBlock((Mob)this.entity, 60, Util::isLand);
    }

    private int getFishCount() {
        return this.fishCaught;
    }

    private boolean ifCaughtFish() {
        return this.fishingTimeout <= 40;
    }

    private void castLine() {
        this.fishingTimeout = 600;
        this.retractLine();
        this.entity.swing(InteractionHand.MAIN_HAND);
        FishingBobberEntity lure = new FishingBobberEntity(this.entity, this.entity.level(), 0, 0);
        this.entity.level().addFreshEntity((Entity)lure);
    }

    private void retractLine() {
        if (this.entity.getLure() != null) {
            this.entity.getLure().remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public void faceCoord(BlockPos coord, float maxDeltaYaw, float maxDeltaPitch) {
        this.faceCoord(coord.getX(), coord.getY(), coord.getZ(), maxDeltaYaw, maxDeltaPitch);
    }

    public void faceCoord(int x, int y, int z, float maxDeltaYaw, float maxDeltaPitch) {
        double d = (double)((float)x + 0.5f) - this.entity.getX();
        double d2 = (double)((float)z + 0.5f) - this.entity.getZ();
        double d1 = (double)((float)y + 0.5f) - (this.entity.getY() + (double)this.entity.getEyeHeight());
        double d3 = Mth.sqrt((float)((float)(d * d + d2 * d2)));
        float f2 = (float)(Math.atan2(d2, d) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
        this.entity.setXRot(-this.updateRotation(this.entity.getXRot(), f3, maxDeltaPitch));
        this.entity.setYRot(this.updateRotation(this.entity.getYRot(), f2, maxDeltaYaw));
    }

    public float updateRotation(float curRotation, float targetRotation, float maxDeltaRotation) {
        float f3;
        for (f3 = targetRotation - curRotation; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        if (f3 > maxDeltaRotation) {
            f3 = maxDeltaRotation;
        }
        if (f3 < -maxDeltaRotation) {
            f3 = -maxDeltaRotation;
        }
        return curRotation + f3;
    }

    static enum FISHING_STATE {
        IDLE,
        WALKING_TO_WATER,
        FISHING,
        RETURN_TO_BASE,
        WALKING_TO_LAND;

    }
}

