/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;

public class EntityAIKoaMate
extends Goal {
    private final EntityKoaBase villagerObj;
    @Nullable
    private EntityKoaBase mate;
    private final Level world;
    private int matingTimeout;
    private final long TIME_BETWEEN_POPULATION_CHECKS = 200L;
    private final int MAX_TOWN_POPULATION = 10;
    private long lastTimeCheckedVillagePopulation = -1L;
    private int cachedVillagePopulation = 0;

    public EntityAIKoaMate(EntityKoaBase villagerIn) {
        this.villagerObj = villagerIn;
        this.world = villagerIn.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.villagerObj.getAge() != 0) {
            return false;
        }
        if (this.villagerObj.getRandom().nextInt(500) != 0) {
            return false;
        }
        if (this.canTownHandleMoreVillagers() && this.villagerObj.getIsWillingToMate(true)) {
            List listEntities = this.world.getEntitiesOfClass(EntityKoaBase.class, this.villagerObj.getBoundingBox().inflate(8.0, 3.0, 8.0));
            EntityKoaBase clEnt = null;
            double clDist = 9999.0;
            for (EntityKoaBase ent : listEntities) {
                if (ent == this.villagerObj || !ent.getIsWillingToMate(true) || ent.isBaby() || this.villagerObj.isBaby() || !((double)this.villagerObj.distanceTo((Entity)ent) < clDist)) continue;
                clEnt = ent;
                clDist = this.villagerObj.distanceTo((Entity)ent);
            }
            if (clEnt != null) {
                this.mate = clEnt;
                return true;
            }
        }
        return false;
    }

    public void start() {
        this.matingTimeout = 300;
        this.villagerObj.setMating(true);
        if (this.mate != null) {
            this.mate.setMating(true);
        }
    }

    public void stop() {
        this.mate = null;
        this.villagerObj.setMating(false);
    }

    public boolean canContinueToUse() {
        boolean result;
        boolean bl = result = this.matingTimeout >= 0 && this.canTownHandleMoreVillagers() && this.villagerObj.getAge() == 0 && this.villagerObj.getIsWillingToMate(false);
        if (!result) {
            // empty if block
        }
        return result;
    }

    public void tick() {
        --this.matingTimeout;
        this.villagerObj.getLookControl().setLookAt((Entity)this.mate, 10.0f, 30.0f);
        if (this.villagerObj.distanceToSqr((Entity)this.mate) > 2.25) {
            this.villagerObj.getNavigation().moveTo((Entity)this.mate, 0.75);
        } else if (this.matingTimeout == 0 && this.mate.isMating()) {
            this.mate.setMating(false);
            this.giveBirth();
        }
        if (this.villagerObj.getRandom().nextInt(35) == 0) {
            this.world.broadcastEntityEvent((Entity)this.villagerObj, (byte)12);
        }
    }

    private boolean canTownHandleMoreVillagers() {
        double range = 100.0;
        if (this.lastTimeCheckedVillagePopulation + 200L < this.world.getGameTime()) {
            this.lastTimeCheckedVillagePopulation = this.world.getGameTime();
            List listEntities = this.world.getEntitiesOfClass(EntityKoaBase.class, this.villagerObj.getBoundingBox().inflate(range, range, range));
            this.cachedVillagePopulation = listEntities.size();
            return listEntities.size() < 10;
        }
        return this.cachedVillagePopulation < 10;
    }

    private void giveBirth() {
        Villager entityvillager = this.villagerObj.getBreedOffspring((ServerLevel)this.world, (AgeableMob)this.mate);
        this.mate.setAge(6000);
        this.villagerObj.setAge(6000);
        this.mate.setIsWillingToMate(false);
        this.villagerObj.setIsWillingToMate(false);
        entityvillager.setAge(-24000);
        entityvillager.moveTo(this.villagerObj.getX(), this.villagerObj.getY(), this.villagerObj.getZ(), 0.0f, 0.0f);
        if (entityvillager instanceof EntityKoaBase) {
            ((EntityKoaBase)entityvillager).setVillageAndDimID(this.villagerObj.getVillageID(), this.villagerObj.getVillageDimension());
            entityvillager.restrictTo(this.villagerObj.getRestrictCenter(), 128);
            ((EntityKoaBase)entityvillager).updateUniqueEntityAI();
            entityvillager.level().playSound(null, entityvillager.blockPosition(), SoundEvents.CHICKEN_EGG, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        this.world.addFreshEntity((Entity)entityvillager);
        this.world.broadcastEntityEvent((Entity)entityvillager, (byte)12);
    }
}

