/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;

public class EntityAIPartyTime
extends Goal {
    private final EntityKoaBase entityObj;
    private final int walkingTimeoutMax = 200;
    private int walkingTimeout;
    private int repathPentalty = 0;
    private int lookUpdateTimer = 0;
    private final int randXPos = 0;
    private final int randYPos = 0;
    private final int randZPos = 0;
    private int assignedDrumIndex = 0;
    private boolean wasClose = false;
    private boolean bangDrum = false;

    public EntityAIPartyTime(EntityKoaBase entityObjIn) {
        this.entityObj = entityObjIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.entityObj.getWantsToParty() && this.entityObj.druggedTime <= 0 || this.entityObj.listPosDrums.isEmpty()) {
            return false;
        }
        BlockPos blockpos = this.entityObj.blockPosition();
        if (this.entityObj.druggedTime > 0 || !this.entityObj.level().isDay() || this.entityObj.level().isRaining() && ((Biome)this.entityObj.level().getBiome(blockpos).value()).getPrecipitationAt(blockpos) != Biome.Precipitation.RAIN) {
            if (!this.isTooClose()) {
                return this.entityObj.level().random.nextInt(20) == 0;
            }
            return false;
        }
        return false;
    }

    public boolean canContinueToUse() {
        BlockPos blockpos = this.entityObj.blockPosition();
        if (this.entityObj.druggedTime > 0 || !this.entityObj.level().isDay() || this.entityObj.level().isRaining() && ((Biome)this.entityObj.level().getBiome(blockpos).value()).getPrecipitationAt(blockpos) != Biome.Precipitation.RAIN) {
            return !this.isTooClose();
        }
        return this.entityObj.level().random.nextInt(60) != 0;
    }

    public void tick() {
        super.tick();
        boolean isClose = false;
        BlockPos blockposGoal = null;
        if (this.entityObj.listPosDrums.size() > this.assignedDrumIndex) {
            blockposGoal = this.entityObj.listPosDrums.get(this.assignedDrumIndex);
        }
        if (this.entityObj.level().getGameTime() % 200L == 0L) {
            if (!this.entityObj.listPosDrums.isEmpty()) {
                this.assignedDrumIndex = this.entityObj.level().random.nextInt(this.entityObj.listPosDrums.size());
            }
            this.bangDrum = this.entityObj.level().random.nextBoolean();
        }
        if (blockposGoal == null) {
            this.stop();
            return;
        }
        double dist = this.entityObj.position().distanceTo(new Vec3((double)blockposGoal.getX(), (double)blockposGoal.getY(), (double)blockposGoal.getZ()));
        if (dist < 8.0) {
            this.wasClose = true;
        }
        if (dist < 3.0 && this.entityObj.onGround()) {
            isClose = true;
            this.entityObj.getNavigation().stop();
            if (!this.bangDrum) {
                this.entityObj.setDancing(true);
                this.entityObj.getJumpControl().jump();
                this.entityObj.setYRot(this.entityObj.level().random.nextInt(360));
            } else {
                this.entityObj.setDancing(false);
                this.entityObj.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                int amp = 1;
                int rate = 4 + this.entityObj.getId() % 7;
                int index1 = 0;
                HashMap<Integer, ArrayList> lookupStateToSequence = new HashMap<Integer, ArrayList>();
                ArrayList listDelays = Lists.newArrayList((Object[])new Integer[]{9, 3, 3, 3, 6});
                lookupStateToSequence.put(index1++, listDelays);
                lookupStateToSequence.put(index1++, listDelays);
                lookupStateToSequence.put(index1++, listDelays);
                lookupStateToSequence.put(index1++, Lists.newArrayList((Object[])new Integer[]{9, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 12}));
                int nightStart = 12500;
                int nightEnd = 23500;
                int phases = 4;
                int phaseSplit = (nightEnd - nightStart) / phases;
                int timeOfDay = (int)(this.entityObj.level().getDayTime() % 24000L);
                int nightTime = timeOfDay - nightStart;
                amp = nightTime > phaseSplit * 3 ? 1 : (nightTime > phaseSplit * 2 ? 2 : (nightTime > phaseSplit * 1 ? 3 : 4));
                if (this.entityObj.hitIndex2 >= ((List)lookupStateToSequence.get(this.entityObj.hitIndex)).size()) {
                    this.entityObj.hitIndex2 = 0;
                    ++this.entityObj.hitIndex;
                }
                if (this.entityObj.hitIndex >= lookupStateToSequence.size()) {
                    this.entityObj.hitIndex = 0;
                }
                rate = (Integer)((List)lookupStateToSequence.get(this.entityObj.hitIndex)).get(this.entityObj.hitIndex2);
                if (this.entityObj.hitDelay > 0) {
                    --this.entityObj.hitDelay;
                }
                boolean perEntDelay = false;
                boolean hit = false;
                if (perEntDelay) {
                    if (this.entityObj.hitDelay <= 0) {
                        this.entityObj.hitDelay = amp * rate;
                        hit = true;
                    }
                } else {
                    boolean bl = hit = this.entityObj.level().getGameTime() % (long)(amp * rate) == 0L;
                }
                if (hit) {
                    ++this.entityObj.hitIndex2;
                    BlockState state = this.entityObj.level().getBlockState(blockposGoal);
                    if (state.getBlock() instanceof NoteBlock) {
                        if (this.entityObj.level().random.nextInt(10) == 0) {
                            for (int i = 0; i < 1 + this.entityObj.level().random.nextInt(4); ++i) {
                                ((BlockState)state.cycle((Property)NoteBlock.NOTE)).getValue((Property)NoteBlock.NOTE);
                            }
                        } else {
                            state.attack(this.entityObj.level(), blockposGoal, (Player)FakePlayerFactory.get((ServerLevel)((ServerLevel)this.entityObj.level()), (GameProfile)new GameProfile(UUID.fromString("e517cf6a-ce31-4ac8-b48d-44b4f0f918a7"), "tropicraftKoa")));
                        }
                        this.entityObj.swing(InteractionHand.MAIN_HAND);
                    }
                }
                this.entityObj.syncBPM();
                this.entityObj.getLookControl().setLookAt((double)(blockposGoal.getX() + 0), (double)(blockposGoal.getY() + 0) + 1.0, (double)(blockposGoal.getZ() + 0), 8.0f, 8.0f);
            }
        } else {
            this.wasClose = false;
            this.entityObj.setSitting(false);
        }
        if (!isClose) {
            this.entityObj.setDancing(true);
            if ((this.entityObj.getNavigation().isDone() || this.walkingTimeout <= 0) && this.repathPentalty <= 0) {
                Vec3 Vector3d;
                int i = blockposGoal.getX();
                int j = blockposGoal.getY();
                int k = blockposGoal.getZ();
                boolean success = false;
                success = this.entityObj.distanceToSqr(Vec3.atCenterOf((Vec3i)blockposGoal)) > 256.0 ? ((Vector3d = DefaultRandomPos.getPosTowards((PathfinderMob)this.entityObj, (int)14, (int)3, (Vec3)new Vec3((double)i + 0.5, (double)j, (double)k + 0.5), (double)1.5707963705062866)) != null ? this.entityObj.getNavigation().moveTo(Vector3d.x, Vector3d.y, Vector3d.z, 1.0) : Util.tryMoveToXYZLongDist((Mob)this.entityObj, new BlockPos(i, j, k), 1.0)) : this.entityObj.getNavigation().moveTo((double)i + 0.5, (double)j, (double)k + 0.5, 1.0);
                if (!success) {
                    this.repathPentalty = 40;
                } else {
                    this.walkingTimeout = 200;
                }
            } else if (this.walkingTimeout > 0) {
                --this.walkingTimeout;
            }
        }
        if (this.repathPentalty > 0) {
            --this.repathPentalty;
        }
        if (this.lookUpdateTimer > 0) {
            --this.lookUpdateTimer;
        }
    }

    public void start() {
        super.start();
        this.entityObj.getNavigation().stop();
        if (!this.entityObj.listPosDrums.isEmpty()) {
            this.assignedDrumIndex = this.entityObj.level().random.nextInt(this.entityObj.listPosDrums.size());
        }
    }

    public void stop() {
        super.stop();
        this.entityObj.setSitting(false);
        this.walkingTimeout = 0;
        this.entityObj.setDancing(false);
    }

    public boolean isTooClose() {
        BlockPos blockposGoal = null;
        blockposGoal = this.entityObj.posLastFireplaceFound != null ? this.entityObj.posLastFireplaceFound.offset(0, -1, 0) : this.entityObj.getRestrictCenter();
        if (blockposGoal == BlockPos.ZERO) {
            return false;
        }
        return this.entityObj.position().closerThan((Position)new Vec3((double)blockposGoal.getX(), (double)blockposGoal.getY(), (double)blockposGoal.getZ()), 1.0);
    }
}

