/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.ashen;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.tropicraft.core.common.entity.hostile.AshenEntity;
import net.tropicraft.core.common.item.AshenMaskItem;

public class AIAshenShootDart
extends Goal {
    private final AshenEntity entity;
    private int attackCooldown;
    private int attackTime = -1;
    private int seeTime;
    private final float maxAttackDistance;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private final float moveSpeedAmplifier;

    public AIAshenShootDart(AshenEntity entity) {
        this.entity = entity;
        this.attackCooldown = 60;
        this.maxAttackDistance = 225.0f;
        this.moveSpeedAmplifier = 1.0f;
    }

    public void setAttackCooldown(int attackCooldown) {
        this.attackCooldown = attackCooldown;
    }

    public boolean canUse() {
        ItemStack headGear;
        if (this.entity.getTarget() != null && (headGear = this.entity.getTarget().getItemBySlot(EquipmentSlot.HEAD)).getItem() instanceof AshenMaskItem) {
            return false;
        }
        return this.entity.getTarget() != null && this.entity.hasMask();
    }

    public boolean canContinueToUse() {
        return this.canUse() || !this.entity.getNavigation().isDone();
    }

    public void stop() {
        super.stop();
        this.seeTime = 0;
        this.attackTime = -1;
        this.entity.stopUsingItem();
    }

    public void tick() {
        LivingEntity target = this.entity.getTarget();
        if (target != null) {
            boolean hasSeenEnemy;
            ItemStack headGear = target.getItemBySlot(EquipmentSlot.HEAD);
            if (headGear.getItem() instanceof AshenMaskItem) {
                return;
            }
            double d0 = this.entity.distanceToSqr(target.getX(), target.getBoundingBox().minY, target.getZ());
            boolean canSeeEnemy = this.entity.getSensing().hasLineOfSight((Entity)target);
            boolean bl = hasSeenEnemy = this.seeTime > 0;
            if (canSeeEnemy != hasSeenEnemy) {
                this.seeTime = 0;
            }
            this.seeTime = canSeeEnemy ? ++this.seeTime : --this.seeTime;
            if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entity.getNavigation().stop();
                ++this.strafingTime;
            } else {
                this.entity.getNavigation().moveTo((Entity)target, (double)this.moveSpeedAmplifier);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.entity.getRandom().nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.entity.getRandom().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.entity.getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.entity.lookAt((Entity)target, 30.0f, 30.0f);
            } else {
                this.entity.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            }
            if (this.entity.isUsingItem()) {
                int i;
                if (!canSeeEnemy && this.seeTime < -60) {
                    this.entity.stopUsingItem();
                } else if (canSeeEnemy && (i = this.entity.getTicksUsingItem()) >= 20) {
                    this.entity.stopUsingItem();
                    this.entity.performRangedAttack(target, 14 - this.entity.level().getDifficulty().getId() * 4);
                    this.attackTime = this.attackCooldown;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.entity.startUsingItem(InteractionHand.MAIN_HAND);
            }
        }
    }
}

