/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.vmonkey;

import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.tropicraft.core.common.drinks.TropicraftDrinks;
import net.tropicraft.core.common.entity.neutral.VMonkeyEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class MonkeySitAndDrinkGoal
extends Goal {
    private static final int DEFAULT_WAIT = 40;
    private final VMonkeyEntity entity;
    private int waitCounter;

    public MonkeySitAndDrinkGoal(VMonkeyEntity monkey) {
        this.entity = monkey;
        this.waitCounter = 40;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public void stop() {
        this.entity.setInSittingPose(false);
        this.entity.spawnAtLocation(new ItemStack((ItemLike)TropicraftItems.BAMBOO_MUG.get()));
        this.entity.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        this.waitCounter = 40;
    }

    public boolean canContinueToUse() {
        return this.entity.selfHoldingDrink(TropicraftDrinks.PINA_COLADA);
    }

    public boolean canUse() {
        return this.entity.selfHoldingDrink(TropicraftDrinks.PINA_COLADA);
    }

    public void start() {
        this.entity.setInSittingPose(true);
        this.entity.setAggressive(false);
        this.entity.setTarget(null);
        this.entity.setFollowing(null);
    }

    public void tick() {
        ItemStack heldStack;
        --this.waitCounter;
        if (this.waitCounter <= 0) {
            this.entity.startUsingItem(InteractionHand.MAIN_HAND);
        }
        if ((heldStack = this.entity.getMainHandItem()).getItem() == TropicraftItems.BAMBOO_MUG.get()) {
            this.entity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 2));
        }
    }
}

