/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.vmonkey;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.tropicraft.core.common.entity.neutral.VMonkeyEntity;
import net.tropicraft.core.common.entity.placeable.ChairEntity;

public class MonkeySitInChairGoal
extends Goal {
    private final VMonkeyEntity entity;

    public MonkeySitInChairGoal(VMonkeyEntity monkey) {
        this.entity = monkey;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    private Optional<ChairEntity> getNearestEmptyChair() {
        List list = this.entity.level().getEntitiesOfClass(ChairEntity.class, this.entity.getBoundingBox().inflate(32.0));
        return list.stream().filter(chair -> !chair.isInvisible() && !chair.isVehicle()).findFirst();
    }

    private boolean isOwnerNear() {
        return this.entity.getOwner() != null && this.entity.getOwner().distanceToSqr((Entity)this.entity) < 32.0;
    }

    private boolean isOwnerNearAndSitting() {
        Entity ridingEntity = this.entity.getOwner().getVehicle();
        return this.isOwnerNear() && ridingEntity instanceof ChairEntity;
    }

    public void stop() {
        this.entity.stopRiding();
        this.entity.setOrderedToSit(false);
    }

    public boolean canUse() {
        if (!this.entity.isTame() || this.entity.getOwner() == null) {
            return false;
        }
        return this.hasNearbyEmptyChair() && this.isOwnerNearAndSitting();
    }

    private boolean hasNearbyEmptyChair() {
        return this.getNearestEmptyChair().isPresent();
    }

    public boolean canContinueToUse() {
        return this.isOwnerNearAndSitting();
    }

    public void start() {
        Optional<ChairEntity> nearbyChair = this.getNearestEmptyChair();
        if (nearbyChair.isPresent()) {
            this.entity.setOrderedToSit(true);
            this.entity.startRiding(nearbyChair.get());
        }
    }
}

