/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.neutral;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.sound.Sounds;

public class EIHEntity
extends PathfinderMob {
    private static final EntityDataAccessor<Byte> STATE = SynchedEntityData.defineId(EIHEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public final int FLAG_SLEEP = 1;
    public final int FLAG_AWARE = 2;
    public final int FLAG_ANGRY = 4;

    public EIHEntity(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
        this.xpReward = 10;
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
    }

    public byte getState() {
        return (Byte)this.getEntityData().get(STATE);
    }

    private void setState(byte state) {
        this.getEntityData().set(STATE, (Object)state);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.createMobAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.KNOCKBACK_RESISTANCE, 100.0).add(Attributes.ATTACK_DAMAGE, 7.0);
    }

    public void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal(this, 1.0, false){

            public boolean canUse() {
                if (!EIHEntity.this.isAngry()) {
                    return false;
                }
                return super.canUse();
            }
        });
        LeapAtTargetGoal leap = new LeapAtTargetGoal((Mob)this, 0.4f);
        this.goalSelector.addGoal(3, (Goal)leap);
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal(this, 0.8){

            public boolean canUse() {
                if (!EIHEntity.this.isAngry()) {
                    return false;
                }
                return super.canUse();
            }
        });
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new TargetAggressorGoal(this));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte("State", this.getState());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setState(compound.getByte("State"));
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public void baseTick() {
        super.baseTick();
        if (this.isAsleep()) {
            this.setDeltaMovement(Vec3.ZERO);
        }
        if (!this.isAsleep()) {
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        if (this.tickCount % 20 == 0) {
            LivingEntity attackTarget = this.getTarget();
            if (attackTarget == null) {
                Player closestPlayer = this.level().getNearestPlayer((Entity)this, 10.0);
                if (closestPlayer != null && !closestPlayer.getAbilities().instabuild && !closestPlayer.isSpectator()) {
                    this.setTarget((LivingEntity)closestPlayer);
                }
            } else if (!this.closerThan((Entity)attackTarget, 16.0)) {
                this.setTarget(null);
                this.setAwake(false);
                this.setImmobile(true);
                this.setAngry(false);
            }
            if (attackTarget != null && !this.isPathFinding() && !this.isAngry() && attackTarget instanceof Player) {
                Player player = (Player)attackTarget;
                if (!player.getAbilities().instabuild && !player.isSpectator()) {
                    if (this.closerThan((Entity)player, 10.0)) {
                        this.setAwake(true);
                        if (this.isAware() && player.getInventory().getSelected().is(TropicraftBlocks.CHUNK.asItem())) {
                            this.setAngry(true);
                            this.setImmobile(false);
                        }
                    }
                    if (this.closerThan((Entity)player, 3.0) && this.level().getDifficulty() != Difficulty.PEACEFUL) {
                        this.setAwake(false);
                        this.setImmobile(false);
                        this.setAngry(true);
                    }
                } else {
                    this.setImmobile(true);
                    this.setAngry(false);
                    this.setAwake(false);
                    this.setDeltaMovement(0.0, -0.1, 0.0);
                    this.setRot(this.yRotO, this.xRotO);
                }
            }
            if (this.isAsleep()) {
                this.setRot(this.yRotO, this.xRotO);
            } else {
                this.setAwake(false);
            }
        }
    }

    public boolean isAngry() {
        return this.getEIHFlag(4);
    }

    public void setAngry(boolean angry) {
        this.setEIHFlag(4, angry);
    }

    public boolean isAware() {
        return this.getEIHFlag(2);
    }

    public void setAwake(boolean aware) {
        this.setEIHFlag(2, aware);
    }

    public boolean isAsleep() {
        return this.getEIHFlag(1);
    }

    public void setImmobile(boolean asleep) {
        this.setEIHFlag(1, asleep);
    }

    public void setEIHFlag(int id, boolean flag) {
        if (flag) {
            this.entityData.set(STATE, (Object)((byte)((Byte)this.entityData.get(STATE) | id)));
        } else {
            this.entityData.set(STATE, (Object)((byte)((Byte)this.entityData.get(STATE) & ~id)));
        }
    }

    private boolean getEIHFlag(int id) {
        return ((Byte)this.entityData.get(STATE) & id) != 0;
    }

    protected SoundEvent getAmbientSound() {
        if (this.isAware()) {
            return this.random.nextInt(10) == 0 ? (SoundEvent)Sounds.HEAD_MED.get() : null;
        }
        if (this.isAngry()) {
            return this.random.nextInt(10) == 0 ? (SoundEvent)Sounds.HEAD_SHORT.get() : null;
        }
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)Sounds.HEAD_PAIN.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)Sounds.HEAD_DEATH.get();
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurt(source, amount);
        }
        Entity entity = source.getDirectEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getAbilities().instabuild || player.isSpectator()) {
                return super.hurt(source, amount);
            }
            if (player.getMainHandItem().isCorrectToolForDrops(TropicraftBlocks.CHUNK.getDefaultState())) {
                return super.hurt(source, amount);
            }
            this.playSound((SoundEvent)Sounds.HEAD_LAUGHING.get(), this.getSoundVolume(), this.getVoicePitch());
            this.setLastHurtByMob((LivingEntity)player);
            this.setAngry(true);
            this.setImmobile(false);
        }
        return true;
    }

    private static class TargetAggressorGoal
    extends NearestAttackableTargetGoal<Player> {
        public TargetAggressorGoal(EIHEntity eih) {
            super((Mob)eih, Player.class, true);
        }

        public boolean canUse() {
            return ((EIHEntity)this.mob).isAngry() && super.canUse();
        }
    }
}

