/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.neutral;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.sound.Sounds;

public class IguanaEntity
extends PathfinderMob {
    private int angerLevel;
    @Nullable
    private UUID angerTargetUUID;
    private static final AttributeModifier ATTACK_SPEED_BOOST_MODIFIER = new AttributeModifier(Tropicraft.location("attack_speed_boost"), 0.05, AttributeModifier.Operation.ADD_VALUE);

    public IguanaEntity(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
    }

    public void setLastHurtByMob(@Nullable LivingEntity entity) {
        super.setLastHurtByMob(entity);
        if (entity != null) {
            this.angerTargetUUID = entity.getUUID();
        }
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.createMobAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 5.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByAggressorGoal(this));
        this.targetSelector.addGoal(2, (Goal)new TargetAggressorGoal(this));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putShort("Anger", (short)this.angerLevel);
        if (this.angerTargetUUID != null) {
            compound.putString("HurtBy", this.angerTargetUUID.toString());
        } else {
            compound.putString("HurtBy", "");
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.angerLevel = compound.getShort("Anger");
        String hurtBy = compound.getString("HurtBy");
        if (!hurtBy.isEmpty()) {
            this.angerTargetUUID = UUID.fromString(hurtBy);
            Player entityplayer = this.level().getPlayerByUUID(this.angerTargetUUID);
            this.setLastHurtByMob((LivingEntity)entityplayer);
            if (entityplayer != null) {
                this.lastHurtByPlayer = entityplayer;
                this.lastHurtByPlayerTime = this.getLastHurtByMobTimestamp();
            }
        }
    }

    protected void customServerAiStep() {
        AttributeInstance attribute = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (this.isAngry()) {
            if (!this.isBaby() && !attribute.hasModifier(ATTACK_SPEED_BOOST_MODIFIER.id())) {
                attribute.addTransientModifier(ATTACK_SPEED_BOOST_MODIFIER);
            }
            --this.angerLevel;
        } else if (attribute.hasModifier(ATTACK_SPEED_BOOST_MODIFIER.id())) {
            attribute.removeModifier(ATTACK_SPEED_BOOST_MODIFIER);
        }
        if (this.angerLevel > 0 && this.angerTargetUUID != null && this.getLastHurtByMob() == null) {
            Player entityplayer = this.level().getPlayerByUUID(this.angerTargetUUID);
            this.setLastHurtByMob((LivingEntity)entityplayer);
            this.lastHurtByPlayer = entityplayer;
            this.lastHurtByPlayerTime = this.getLastHurtByMobTimestamp();
        }
        super.customServerAiStep();
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        if (this.isInvulnerableTo(damageSource)) {
            return false;
        }
        Entity sourceEntity = damageSource.getEntity();
        if (sourceEntity instanceof Player && !((Player)sourceEntity).isCreative() && this.hasLineOfSight(sourceEntity)) {
            this.becomeAngryAt(sourceEntity);
        }
        return super.hurt(damageSource, amount);
    }

    private boolean becomeAngryAt(Entity target) {
        this.angerLevel = 400 + this.random.nextInt(400);
        if (target instanceof LivingEntity) {
            this.setLastHurtByMob((LivingEntity)target);
        }
        return true;
    }

    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)Sounds.IGGY_LIVING.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)Sounds.IGGY_ATTACK.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)Sounds.IGGY_DEATH.get();
    }

    static class HurtByAggressorGoal
    extends HurtByTargetGoal {
        public HurtByAggressorGoal(IguanaEntity iguana) {
            super((PathfinderMob)iguana, new Class[0]);
            this.setAlertOthers(new Class[]{IguanaEntity.class});
        }

        protected void alertOther(Mob mob, LivingEntity target) {
            if (mob instanceof IguanaEntity && this.mob.hasLineOfSight((Entity)target) && ((IguanaEntity)mob).becomeAngryAt((Entity)target)) {
                mob.setTarget(target);
            }
        }
    }

    static class TargetAggressorGoal
    extends NearestAttackableTargetGoal<Player> {
        public TargetAggressorGoal(IguanaEntity iggy) {
            super((Mob)iggy, Player.class, true);
        }

        public boolean canUse() {
            return ((IguanaEntity)this.mob).isAngry() && super.canUse();
        }
    }
}

