/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.neutral;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.TropicraftDrinks;
import net.tropicraft.core.common.entity.ai.vmonkey.MonkeyAngryThrowGoal;
import net.tropicraft.core.common.entity.ai.vmonkey.MonkeyFollowNearestPinaColadaHolderGoal;
import net.tropicraft.core.common.entity.ai.vmonkey.MonkeyPickUpPinaColadaGoal;
import net.tropicraft.core.common.entity.ai.vmonkey.MonkeySitAndDrinkGoal;
import net.tropicraft.core.common.entity.ai.vmonkey.MonkeySitInChairGoal;
import net.tropicraft.core.common.entity.ai.vmonkey.MonkeyStealDrinkGoal;
import net.tropicraft.core.common.item.CocktailItem;

public class VMonkeyEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Byte> DATA_FLAGS = SynchedEntityData.defineId(VMonkeyEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final int FLAG_CLIMBING = 1;
    public static final Predicate<LivingEntity> FOLLOW_PREDICATE = ent -> {
        if (ent == null) {
            return false;
        }
        if (!(ent instanceof Player)) {
            return false;
        }
        Player player = (Player)ent;
        return CocktailItem.hasDrink(player.getMainHandItem(), TropicraftDrinks.PINA_COLADA) || CocktailItem.hasDrink(player.getOffhandItem(), TropicraftDrinks.PINA_COLADA);
    };
    @Nullable
    private LivingEntity following;
    private boolean madAboutStolenAlcohol;

    public VMonkeyEntity(EntityType<? extends TamableAnimal> type, Level world) {
        super(type, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FLAGS, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return TamableAnimal.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new MonkeyFollowNearestPinaColadaHolderGoal(this, 1.0, 2.0f, 10.0f));
        this.goalSelector.addGoal(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(3, (Goal)new MonkeyPickUpPinaColadaGoal(this));
        this.goalSelector.addGoal(2, (Goal)new MonkeyStealDrinkGoal(this));
        this.goalSelector.addGoal(2, (Goal)new MonkeySitAndDrinkGoal(this));
        this.goalSelector.addGoal(2, (Goal)new MonkeyAngryThrowGoal(this));
        this.goalSelector.addGoal(4, (Goal)new MonkeySitInChairGoal(this));
        this.goalSelector.addGoal(4, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(7, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte("MonkeyFlags", this.getMonkeyFlags());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setMonkeyFlags(compound.getByte("MonkeyFlags"));
    }

    @Nullable
    public LivingEntity getFollowing() {
        return this.following;
    }

    public void setFollowing(@Nullable LivingEntity following) {
        this.following = following;
    }

    public boolean selfHoldingDrink(ResourceKey<Drink> drink) {
        return CocktailItem.hasDrink(this.getMainHandItem(), drink);
    }

    private void setMonkeyFlags(byte flags) {
        this.getEntityData().set(DATA_FLAGS, (Object)flags);
    }

    private byte getMonkeyFlags() {
        return (Byte)this.getEntityData().get(DATA_FLAGS);
    }

    public boolean isClimbing() {
        return this.getMonkeyFlag(1);
    }

    private void setClimbing(boolean state) {
        this.setMonkeyFlag(1, state);
    }

    public void setMonkeyFlag(int id, boolean flag) {
        if (flag) {
            this.entityData.set(DATA_FLAGS, (Object)((byte)((Byte)this.entityData.get(DATA_FLAGS) | id)));
        } else {
            this.entityData.set(DATA_FLAGS, (Object)((byte)((Byte)this.entityData.get(DATA_FLAGS) & ~id)));
        }
    }

    private boolean getMonkeyFlag(int flag) {
        return ((Byte)this.entityData.get(DATA_FLAGS) & flag) != 0;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)player) && !this.level().isClientSide) {
                this.setOrderedToSit(!this.isOrderedToSit());
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
                this.setAggressive(false);
            }
        } else if (!stack.isEmpty() && this.isFood(stack)) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            if (!this.level().isClientSide) {
                if (this.random.nextInt(3) == 0) {
                    this.setTame(true, true);
                    this.navigation.stop();
                    this.setTarget(null);
                    this.setOrderedToSit(true);
                    this.setHealth(20.0f);
                    this.setOwnerUUID(player.getUUID());
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
            }
            return InteractionResult.PASS;
        }
        return super.mobInteract(player, hand);
    }

    public boolean isFood(ItemStack stack) {
        Holder<Drink> drink = CocktailItem.getDrink(stack);
        return drink != null && drink.is(TropicraftDrinks.PINA_COLADA);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return null;
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        return !this.isTame() && target.getType() == EntityType.PLAYER;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        Entity entity = source.getEntity();
        this.setOrderedToSit(false);
        if (entity != null && entity.getType() != EntityType.PLAYER && !(entity instanceof Arrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.hurt(source, amount);
    }

    public boolean isMadAboutStolenAlcohol() {
        return this.madAboutStolenAlcohol;
    }

    public void setMadAboutStolenAlcohol(boolean madAboutStolenAlcohol) {
        this.madAboutStolenAlcohol = madAboutStolenAlcohol;
    }
}

