/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class FiddlerCrabEntity
extends Animal
implements OwnableEntity {
    private boolean rollingDownTown;
    private boolean travellingGolf;
    @Nullable
    private UUID owner = null;
    private static final String OWNER_UUID_TAG = "Owner";
    private static final String ROLLING_DOWN_TOWN_TAG = "RollingDownTown";

    public FiddlerCrabEntity(EntityType<? extends FiddlerCrabEntity> type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 0.0f);
        this.moveControl = new CrabMoveController((Mob)this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, (double)0.15f).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void updateWalkAnimation(float distance) {
        float rotation = Math.abs(Mth.wrapDegrees((float)(this.yBodyRot - this.yBodyRotO)));
        float targetAmount = distance * 4.0f + rotation * 0.25f;
        targetAmount = Math.min(targetAmount, 0.25f);
        this.walkAnimation.update(targetAmount, 0.4f);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!this.rollingDownTown) {
            return super.hurt(source, amount);
        }
        if (this.owner != null && !this.wasHurtByOwner(source)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    private boolean wasHurtByOwner(DamageSource source) {
        UUID sourceId = source.getEntity() != null ? source.getEntity().getUUID() : null;
        return this.owner != null && this.owner.equals(sourceId);
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public FiddlerCrabEntity getBreedOffspring(ServerLevel world, AgeableMob mate) {
        return null;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected boolean isAffectedByFluids() {
        return !this.onGround();
    }

    public int getMaxHeadYRot() {
        return 30;
    }

    public void travel(Vec3 input) {
        if (this.rollingDownTown) {
            this.travelGolf(input);
        } else {
            super.travel(input);
        }
    }

    public void knockback(double strength, double x, double z) {
        if (this.rollingDownTown) {
            boolean onGround = this.onGround();
            this.setOnGround(false);
            super.knockback(strength, x, z);
            this.setOnGround(onGround);
        } else {
            super.knockback(strength, x, z);
        }
    }

    private void travelGolf(Vec3 input) {
        if (!this.isControlledByLocalInstance() || this.isFallFlying()) {
            super.travel(input);
            return;
        }
        FluidState fluid = this.level().getFluidState(this.blockPosition());
        if (this.isAffectedByFluids() && !this.canStandOnFluid(fluid) && (this.isInWater() || this.isInLava() || this.isInFluidType(fluid))) {
            super.travel(input);
            return;
        }
        try {
            this.setOnGround(false);
            this.travellingGolf = true;
            super.travel(input);
        }
        finally {
            this.travellingGolf = false;
        }
    }

    public BlockPos getBlockPosBelowThatAffectsMyMovement() {
        if (this.travellingGolf) {
            return this.blockPosition().atY(this.level().getMinBuildHeight() - 1);
        }
        return super.getBlockPosBelowThatAffectsMyMovement();
    }

    public boolean isPushable() {
        return !this.rollingDownTown;
    }

    protected void checkFallDamage(double y, boolean ground, BlockState state, BlockPos pos) {
        if (this.rollingDownTown) {
            this.resetFallDistance();
        }
        super.checkFallDamage(y, ground, state, pos);
    }

    public boolean bounce() {
        if (this.rollingDownTown) {
            Vec3 deltaMovement = this.getDeltaMovement();
            if (Math.abs(deltaMovement.y) > 0.1) {
                this.setDeltaMovement(deltaMovement.x, -deltaMovement.y * 0.8, deltaMovement.z);
                return true;
            }
        }
        return false;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean(ROLLING_DOWN_TOWN_TAG, this.rollingDownTown);
        UUID ownerUUID = this.getOwnerUUID();
        if (ownerUUID != null) {
            tag.putUUID(OWNER_UUID_TAG, ownerUUID);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.rollingDownTown = tag.getBoolean(ROLLING_DOWN_TOWN_TAG);
        if (tag.contains(OWNER_UUID_TAG)) {
            this.setOwnerUUID(tag.getUUID(OWNER_UUID_TAG));
        } else {
            this.setOwnerUUID(null);
        }
    }

    public boolean isRollingDownTown() {
        return this.rollingDownTown;
    }

    public float maxUpStep() {
        if (this.rollingDownTown) {
            return 0.0f;
        }
        return super.maxUpStep();
    }

    public static boolean canCrabSpawn(EntityType<? extends FiddlerCrabEntity> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        BlockPos groundPos = pos.below();
        BlockState groundBlock = world.getBlockState(groundPos);
        if (!groundBlock.is(BlockTags.SAND)) {
            return false;
        }
        if (!groundBlock.isValidSpawn((BlockGetter)world, groundPos, type)) {
            return false;
        }
        BlockState block = world.getBlockState(pos);
        FluidState fluid = world.getFluidState(pos);
        return !block.isCollisionShapeFullBlock((BlockGetter)world, pos) && !block.isSignalSource() && !block.is(BlockTags.PREVENT_MOB_SPAWNING_INSIDE) && (fluid.isEmpty() || fluid.is(FluidTags.WATER));
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.owner;
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.owner = uuid;
    }

    static final class CrabMoveController
    extends MoveControl {
        private static final double RAD_TO_DEG = 57.29577951308232;

        CrabMoveController(Mob mob) {
            super(mob);
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                this.operation = MoveControl.Operation.WAIT;
                this.tickMoveTo();
            } else if (this.operation == MoveControl.Operation.WAIT) {
                this.mob.setZza(0.0f);
                this.mob.setXxa(0.0f);
            }
        }

        private void tickMoveTo() {
            double dx = this.wantedX - this.mob.getX();
            double dz = this.wantedZ - this.mob.getZ();
            double dy = this.wantedY - this.mob.getY();
            double distance2 = dx * dx + dy * dy + dz * dz;
            if (distance2 < 2.5E-7) {
                this.mob.setZza(0.0f);
                this.mob.setXxa(0.0f);
                return;
            }
            float forward = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            float leftTarget = forward - 90.0f;
            float rightTarget = forward + 90.0f;
            float yaw = this.mob.getYRot();
            float targetYaw = CrabMoveController.closerAngle(yaw, leftTarget, rightTarget);
            float speed = (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED));
            float strafe = targetYaw < forward ? -1.0f : 1.0f;
            this.mob.setYRot(this.rotlerp(yaw, targetYaw, 10.0f));
            this.mob.setSpeed(speed);
            this.mob.setZza(0.0f);
            this.mob.setXxa(strafe * speed);
        }

        private static float closerAngle(float reference, float left, float right) {
            float deltaRight;
            float deltaLeft = Math.abs(Mth.wrapDegrees((float)(reference - left)));
            if (deltaLeft < (deltaRight = Math.abs(Mth.wrapDegrees((float)(reference - right))))) {
                return left;
            }
            return right;
        }
    }
}

