/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;

public class FishingBobberEntity
extends Entity
implements IEntityWithComplexSpawn {
    private static final EntityDataAccessor<Integer> DATA_HOOKED_ENTITY = SynchedEntityData.defineId(FishingBobberEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean inGround;
    private int ticksInGround;
    @Nullable
    private EntityKoaBase angler;
    private int ticksInAir;
    private int ticksCatchable;
    private int ticksCaughtDelay;
    private int ticksCatchableDelay;
    private float fishApproachAngle;
    @Nullable
    public Entity caughtEntity;
    private State currentState = State.FLYING;
    private int luck;
    private int lureSpeed;

    private FishingBobberEntity(Level p_i50219_1_, EntityKoaBase koaBase, int luck, int lureSpeed) {
        super((EntityType)TropicraftEntities.FISHING_BOBBER.get(), p_i50219_1_);
        this.noCulling = true;
        this.angler = koaBase;
        this.angler.setLure(this);
        this.luck = Math.max(0, luck);
        this.lureSpeed = Math.max(0, lureSpeed);
    }

    public FishingBobberEntity(EntityKoaBase p_i50220_1_, Level p_i50220_2_, int p_i50220_3_, int p_i50220_4_) {
        this(p_i50220_2_, p_i50220_1_, p_i50220_3_, p_i50220_4_);
        float f = this.angler.getXRot();
        float f1 = this.angler.getYRot();
        float f2 = Mth.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        double d0 = this.angler.getX() - (double)f3 * 0.3;
        double d1 = this.angler.getY() + (double)this.angler.getEyeHeight();
        double d2 = this.angler.getZ() - (double)f2 * 0.3;
        this.moveTo(d0, d1, d2, f1, f);
        Vec3 Vector3d = new Vec3((double)(-f3), (double)Mth.clamp((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = Vector3d.length();
        Vector3d = Vector3d.multiply(0.6 / d3 + 0.5 + this.random.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.random.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.random.nextGaussian() * 0.0045);
        this.setDeltaMovement(Vector3d);
        this.setYRot((float)(Mth.atan2((double)Vector3d.x, (double)Vector3d.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)Vector3d.y, (double)Mth.sqrt((float)((float)this.distanceToSqr(Vector3d)))) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public FishingBobberEntity(EntityType<FishingBobberEntity> type, Level world) {
        super(type, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_HOOKED_ENTITY, (Object)0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (DATA_HOOKED_ENTITY.equals(key)) {
            int i = (Integer)this.getEntityData().get(DATA_HOOKED_ENTITY);
            this.caughtEntity = i > 0 ? this.level().getEntity(i - 1) : null;
        }
        super.onSyncedDataUpdated(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = 64.0;
        return distance < 4096.0;
    }

    public AABB getBoundingBoxForCulling() {
        return this.getBoundingBox().inflate(8.0, 5.0, 8.0);
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
    }

    public void tick() {
        super.tick();
        if (this.angler == null) {
            if (this.tickCount > 40) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            return;
        }
        if (this.level().isClientSide || !this.shouldStopFishing()) {
            if (this.inGround) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.remove(Entity.RemovalReason.DISCARDED);
                    return;
                }
            }
            float f = 0.0f;
            BlockPos blockpos = this.blockPosition();
            FluidState ifluidstate = this.level().getFluidState(blockpos);
            if (ifluidstate.is(FluidTags.WATER)) {
                f = ifluidstate.getHeight((BlockGetter)this.level(), blockpos);
            }
            if (this.currentState == State.FLYING) {
                if (this.caughtEntity != null) {
                    this.setDeltaMovement(Vec3.ZERO);
                    this.currentState = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (f > 0.0f) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.3, 0.2, 0.3));
                    this.currentState = State.BOBBING;
                    return;
                }
                if (!this.level().isClientSide) {
                    this.checkCollision();
                }
                if (!(this.inGround || this.onGround() || this.horizontalCollision)) {
                    ++this.ticksInAir;
                } else {
                    this.ticksInAir = 0;
                    this.setDeltaMovement(Vec3.ZERO);
                }
            } else {
                if (this.currentState == State.HOOKED_IN_ENTITY) {
                    if (this.caughtEntity != null) {
                        if (this.caughtEntity.isRemoved()) {
                            this.caughtEntity = null;
                            this.currentState = State.FLYING;
                        } else {
                            this.setPos(this.caughtEntity.getX(), this.caughtEntity.getBoundingBox().minY + (double)this.caughtEntity.getBbHeight() * 0.8, this.caughtEntity.getZ());
                            this.setPos(this.getX(), this.getY(), this.getZ());
                        }
                    }
                    return;
                }
                if (this.currentState == State.BOBBING) {
                    Vec3 Vector3d = this.getDeltaMovement();
                    double d0 = this.getY() + Vector3d.y - (double)blockpos.getY() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.setDeltaMovement(Vector3d.x * 0.9, Vector3d.y - d0 * (double)this.random.nextFloat() * 0.2, Vector3d.z * 0.9);
                    if (!this.level().isClientSide && f > 0.0f) {
                        this.catchingFish(blockpos);
                    }
                }
            }
            if (!ifluidstate.is(FluidTags.WATER)) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.updateRotation();
            double d1 = 0.92;
            this.setDeltaMovement(this.getDeltaMovement().scale(0.92));
            this.setPos(this.getX(), this.getY(), this.getZ());
        }
    }

    private boolean shouldStopFishing() {
        ItemStack itemstack = this.angler.getMainHandItem();
        ItemStack itemstack1 = this.angler.getOffhandItem();
        boolean flag = itemstack.getItem() instanceof FishingRodItem;
        boolean flag1 = itemstack1.getItem() instanceof FishingRodItem;
        if (!this.angler.isRemoved() && this.angler.isAlive() && (flag || flag1) && !(this.distanceToSqr((Entity)this.angler) > 1024.0)) {
            return false;
        }
        this.remove(Entity.RemovalReason.DISCARDED);
        return true;
    }

    private void updateRotation() {
        Vec3 Vector3d = this.getDeltaMovement();
        float f = Mth.sqrt((float)((float)this.distanceToSqr(Vector3d)));
        this.setYRot((float)(Mth.atan2((double)Vector3d.x, (double)Vector3d.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)Vector3d.y, (double)f) * 57.2957763671875));
        while (this.getXRot() - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.getXRot() - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.getYRot() - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.getYRot() - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        this.setXRot(Mth.lerp((float)0.2f, (float)this.xRotO, (float)this.getXRot()));
        this.setYRot(Mth.lerp((float)0.2f, (float)this.yRotO, (float)this.getYRot()));
    }

    private void checkCollision() {
        HitResult result = ProjectileUtil.getHitResultOnMoveVector((Entity)this, entity -> !(entity.isSpectator() || !entity.isPickable() && !(entity instanceof ItemEntity) || entity == this.angler && this.ticksInAir < 5));
        if (result.getType() != HitResult.Type.MISS) {
            if (result.getType() == HitResult.Type.ENTITY) {
                this.caughtEntity = ((EntityHitResult)result).getEntity();
                this.setHookedEntity();
            } else {
                this.inGround = true;
            }
        }
    }

    private void setHookedEntity() {
        this.getEntityData().set(DATA_HOOKED_ENTITY, (Object)(this.caughtEntity.getId() + 1));
    }

    private void catchingFish(BlockPos p_190621_1_) {
        ServerLevel level = (ServerLevel)this.level();
        int i = 1;
        BlockPos blockpos = p_190621_1_.above();
        if (this.random.nextFloat() < 0.25f && this.level().isRainingAt(blockpos)) {
            ++i;
        }
        if (this.random.nextFloat() < 0.5f && !this.level().canSeeSkyFromBelowWater(blockpos)) {
            --i;
        }
        if (this.ticksCatchable > 0) {
            --this.ticksCatchable;
            if (this.ticksCatchable <= 0) {
                this.ticksCaughtDelay = 0;
                this.ticksCatchableDelay = 0;
            } else {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.2 * (double)this.random.nextFloat() * (double)this.random.nextFloat(), 0.0));
            }
        } else if (this.ticksCatchableDelay > 0) {
            this.ticksCatchableDelay -= i;
            if (this.ticksCatchableDelay > 0) {
                double d2;
                double d1;
                this.fishApproachAngle = (float)((double)this.fishApproachAngle + this.random.nextGaussian() * 4.0);
                float f = this.fishApproachAngle * ((float)Math.PI / 180);
                float f1 = Mth.sin((float)f);
                float f2 = Mth.cos((float)f);
                double d0 = this.getX() + (double)(f1 * (float)this.ticksCatchableDelay * 0.1f);
                if (level.getFluidState(BlockPos.containing((double)d0, (double)((d1 = (double)((float)Mth.floor((double)this.getBoundingBox().minY) + 1.0f)) - 1.0), (double)(d2 = this.getX() + (double)(f2 * (float)this.ticksCatchableDelay * 0.1f)))).is(FluidTags.WATER)) {
                    if (this.random.nextFloat() < 0.15f) {
                        level.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    level.sendParticles((ParticleOptions)ParticleTypes.FISHING, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    level.sendParticles((ParticleOptions)ParticleTypes.FISHING, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                Vec3 Vector3d = this.getDeltaMovement();
                this.setDeltaMovement(Vector3d.x, -0.4f * Mth.nextFloat((RandomSource)this.random, (float)0.6f, (float)1.0f), Vector3d.z);
                this.playSound(SoundEvents.FISHING_BOBBER_SPLASH, 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                double d3 = this.getBoundingBox().minY + 0.5;
                level.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, this.getX(), d3, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), (double)0.2f);
                level.sendParticles((ParticleOptions)ParticleTypes.FISHING, this.getX(), d3, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), (double)0.2f);
                this.ticksCatchable = Mth.nextInt((RandomSource)this.random, (int)20, (int)40);
            }
        } else if (this.ticksCaughtDelay > 0) {
            this.ticksCaughtDelay -= i;
            float f5 = 0.15f;
            if (this.ticksCaughtDelay < 20) {
                f5 = (float)((double)f5 + (double)(20 - this.ticksCaughtDelay) * 0.05);
            } else if (this.ticksCaughtDelay < 40) {
                f5 = (float)((double)f5 + (double)(40 - this.ticksCaughtDelay) * 0.02);
            } else if (this.ticksCaughtDelay < 60) {
                f5 = (float)((double)f5 + (double)(60 - this.ticksCaughtDelay) * 0.01);
            }
            if (this.random.nextFloat() < f5) {
                double d6;
                double d5;
                float f6 = Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = Mth.nextFloat((RandomSource)this.random, (float)25.0f, (float)60.0f);
                double d4 = this.getX() + (double)(Mth.sin((float)f6) * f7 * 0.1f);
                if (level.getFluidState(BlockPos.containing((double)d4, (double)((d5 = (double)((float)Mth.floor((double)this.getBoundingBox().minY) + 1.0f)) - 1.0), (double)(d6 = this.getZ() + (double)(Mth.cos((float)f6) * f7 * 0.1f)))).is(FluidTags.WATER)) {
                    level.sendParticles((ParticleOptions)ParticleTypes.SPLASH, d4, d5, d6, 2 + this.random.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.ticksCaughtDelay <= 0) {
                this.fishApproachAngle = Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)360.0f);
                this.ticksCatchableDelay = Mth.nextInt((RandomSource)this.random, (int)20, (int)80);
            }
        } else {
            this.ticksCaughtDelay = Mth.nextInt((RandomSource)this.random, (int)100, (int)600);
            this.ticksCaughtDelay -= this.lureSpeed * 20 * 5;
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
    }

    public void readAdditionalSaveData(CompoundTag compound) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 31 && this.level().isClientSide && this.caughtEntity instanceof Player && ((Player)this.caughtEntity).isLocalPlayer()) {
            this.bringInHookedEntity();
        }
        super.handleEntityEvent(id);
    }

    protected void bringInHookedEntity() {
        if (this.angler != null) {
            Vec3 Vector3d = new Vec3(this.angler.getX() - this.getX(), this.angler.getY() - this.getY(), this.angler.getZ() - this.getZ()).scale(0.1);
            this.caughtEntity.setDeltaMovement(this.caughtEntity.getDeltaMovement().add(Vector3d));
        }
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        if (this.angler != null) {
            this.angler.setLure(null);
        }
    }

    @Nullable
    public EntityKoaBase getAngler() {
        return this.angler;
    }

    public boolean canChangeDimensions(Level oldLevel, Level newLevel) {
        return false;
    }

    public void writeSpawnData(RegistryFriendlyByteBuf data) {
        EntityKoaBase entity = this.getAngler();
        data.writeInt(entity == null ? -1 : entity.getId());
    }

    public void readSpawnData(RegistryFriendlyByteBuf data) {
        Entity entity;
        int anglerID = data.readInt();
        if (anglerID != -1 && (entity = this.level().getEntity(anglerID)) instanceof EntityKoaBase) {
            this.angler = (EntityKoaBase)entity;
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractFish.createAttributes().add(Attributes.MAX_HEALTH, 10.0);
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

