/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.BinaryAnimation;
import net.tropicraft.core.common.Easings;
import net.tropicraft.core.common.entity.IkWalker;

public class ShoebillStorkEntity
extends Animal {
    public static final float BASE_FOOT_Z = 0.0152f;
    private final IkWalker walker = new IkWalker(6, 4, 20, 0.25f);
    private final IkWalker.Foot leftFoot = this.walker.addFoot(0.0152f, -0.1168f);
    private final IkWalker.Foot rightFoot = this.walker.addFoot(0.0152f, 0.1168f);
    private final BinaryAnimation flightAnimation = new BinaryAnimation(3, Easings::inOutSine);

    public ShoebillStorkEntity(EntityType<? extends ShoebillStorkEntity> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.08);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of((TagKey)ItemTags.FISHES), false));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            Vec3 deltaMovement = this.getDeltaMovement();
            if (!this.moveControl.hasWanted() && !this.onGround() && deltaMovement.y < 0.0) {
                this.setDeltaMovement(deltaMovement.multiply(1.0, 0.8, 1.0));
            }
        }
    }

    public void calculateEntityAnimation(boolean includeHeight) {
        super.calculateEntityAnimation(includeHeight);
        if (this.level().isClientSide()) {
            this.flightAnimation.tick(!this.onGround());
            this.walker.update((Mob)this);
        }
    }

    public void absMoveTo(double x, double y, double z) {
        super.absMoveTo(x, y, z);
        this.walker.reset((Mob)this);
    }

    public void moveTo(double x, double y, double z, float yRot, float xRot) {
        super.moveTo(x, y, z, yRot, xRot);
        this.walker.reset((Mob)this);
    }

    public IkWalker.Foot leftFoot() {
        return this.leftFoot;
    }

    public IkWalker.Foot rightFoot() {
        return this.rightFoot;
    }

    public float getFlightAnimation(float partialTicks) {
        return this.flightAnimation.get(partialTicks);
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public ShoebillStorkEntity getBreedOffspring(ServerLevel world, AgeableMob mate) {
        return null;
    }
}

