/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive.basilisk;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.BinaryAnimation;
import net.tropicraft.core.common.Easings;
import net.tropicraft.core.common.entity.passive.basilisk.WaterWalking;

public final class BasiliskLizardEntity
extends Animal {
    private static final EntityDataAccessor<Boolean> RUNNING = SynchedEntityData.defineId(BasiliskLizardEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final float WATER_WALK_SPEED_BOOST = 1.6f;
    private static final int WATER_WALK_TIME = 10;
    private int movingTimer;
    private boolean onWaterSurface;
    private final BinaryAnimation runningAnimation = new BinaryAnimation(10, 5, Easings::inOutSine);

    public BasiliskLizardEntity(EntityType<? extends BasiliskLizardEntity> type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterWalking.Navigator((Mob)this, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RUNNING, (Object)false);
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public BasiliskLizardEntity getBreedOffspring(ServerLevel world, AgeableMob mate) {
        return null;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            this.tickMovementTimer();
            this.tickSwimming();
            this.entityData.set(RUNNING, (Object)this.onWaterSurface);
        } else {
            this.tickRunningAnimation();
        }
    }

    private void tickRunningAnimation() {
        boolean running = (Boolean)this.entityData.get(RUNNING);
        this.runningAnimation.tick(running);
        if (running) {
            this.spawnRunningParticles();
        }
    }

    private void spawnRunningParticles() {
        for (int i = 0; i < 2; ++i) {
            Vec3 motion = this.getDeltaMovement();
            double surfaceY = (double)Mth.floor((double)this.getY()) + 1.0;
            double dx = (this.random.nextDouble() * 2.0 - 1.0) * 0.25;
            double dz = (this.random.nextDouble() * 2.0 - 1.0) * 0.25;
            this.level().addParticle((ParticleOptions)(this.random.nextBoolean() ? ParticleTypes.BUBBLE : ParticleTypes.SPLASH), this.getX() + dx, surfaceY, this.getZ() + dz, motion.x, motion.y - this.random.nextDouble() * (double)0.2f, motion.z);
        }
    }

    protected void doWaterSplashEffect() {
        float volume = (float)(this.getDeltaMovement().multiply(0.5, 1.0, 0.5).length() * (double)0.2f);
        volume = Math.min(volume, 1.0f);
        float pitch = 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f;
        SoundEvent sound = (double)volume < 0.25 ? this.getSwimSplashSound() : this.getSwimHighSpeedSplashSound();
        this.playSound(sound, volume, pitch);
    }

    private void tickMovementTimer() {
        if (this.zza != 0.0f) {
            this.movingTimer = 10;
        } else if (this.movingTimer > 0) {
            --this.movingTimer;
        }
    }

    private void tickSwimming() {
        boolean shouldWaterWalk;
        if (!this.onWaterSurface && this.isInWater() && this.getFluidHeight(FluidTags.WATER) > this.getFluidJumpThreshold() && ((shouldWaterWalk = this.shouldWaterWalk()) || this.random.nextFloat() < 0.8f)) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5).add(0.0, 0.1, 0.0));
        }
    }

    protected Vec3 maybeBackOffFromEdge(Vec3 offset, MoverType mover) {
        if (this.shouldWaterWalk()) {
            Vec3 result = WaterWalking.collide((BlockGetter)this.level(), this.getBoundingBox(), offset);
            this.onWaterSurface = offset.y < 0.0 && result.y != offset.y;
            return result;
        }
        this.onWaterSurface = false;
        return offset;
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.setOnGround(this.onGround() || this.onWaterSurface);
        super.checkFallDamage(y, this.onGround(), state, pos);
    }

    public float getSpeed() {
        float speed = super.getSpeed();
        return this.onWaterSurface ? speed * 1.6f : speed;
    }

    public boolean canStandOnFluid(FluidState fluidState) {
        return WaterWalking.canWalkOn(fluidState.getType());
    }

    private boolean shouldWaterWalk() {
        return this.movingTimer > 0;
    }

    public float getRunningAnimation(float partialTicks) {
        return this.runningAnimation.get(partialTicks);
    }
}

