/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive.basilisk;

import com.google.common.collect.AbstractIterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class WaterWalking {
    private static final double HEIGHT = 0.875;
    public static final VoxelShape COLLIDER = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);

    public static boolean canWalkOn(FluidState fluid) {
        return !fluid.isEmpty() && WaterWalking.canWalkOn(fluid.getType()) && fluid.getAmount() == 8;
    }

    public static boolean canWalkOn(Fluid fluid) {
        return fluid.is(FluidTags.WATER);
    }

    public static Vec3 collide(BlockGetter world, AABB box, Vec3 offset) {
        if (offset.lengthSqr() == 0.0 || offset.y >= 0.0) {
            return offset;
        }
        Iterable<VoxelShape> collisions = WaterWalking.collisions(world, box.expandTowards(offset));
        double dy = Shapes.collide((Direction.Axis)Direction.Axis.Y, (AABB)box, collisions, (double)offset.y);
        return new Vec3(offset.x, dy, offset.z);
    }

    public static Iterable<VoxelShape> collisions(BlockGetter world, AABB box) {
        return () -> new CollisionIterator(world, box);
    }

    public static final class CollisionIterator
    extends AbstractIterator<VoxelShape> {
        private final BlockGetter world;
        private final AABB box;
        private final Cursor3D iterator;
        private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();

        CollisionIterator(BlockGetter world, AABB box) {
            this.world = world;
            this.box = box;
            this.iterator = new Cursor3D(Mth.floor((double)box.minX), Mth.floor((double)box.minY), Mth.floor((double)box.minZ), Mth.floor((double)box.maxX), Mth.floor((double)box.maxY), Mth.floor((double)box.maxZ));
        }

        protected VoxelShape computeNext() {
            BlockGetter world = this.world;
            Cursor3D iterator = this.iterator;
            BlockPos.MutableBlockPos mutablePos = this.mutablePos;
            while (iterator.advance()) {
                int z;
                int y;
                int x = iterator.nextX();
                if (!WaterWalking.canWalkOn(world.getFluidState((BlockPos)mutablePos.set(x, y = iterator.nextY(), z = iterator.nextZ()))) || !this.box.intersects((double)x, (double)y, (double)z, (double)x + 1.0, (double)y + 0.875, (double)z + 1.0)) continue;
                return COLLIDER.move((double)x, (double)y, (double)z);
            }
            return (VoxelShape)this.endOfData();
        }
    }

    public static final class Navigator
    extends GroundPathNavigation {
        public Navigator(Mob entity, Level world) {
            super(entity, world);
            this.setCanFloat(true);
        }

        protected PathFinder createPathFinder(int depth) {
            this.nodeEvaluator = new WalkNodeEvaluator();
            return new PathFinder(this.nodeEvaluator, depth);
        }

        protected boolean hasValidPathType(PathType type) {
            return type == PathType.WATER || type == PathType.WATER_BORDER || super.hasValidPathType(type);
        }

        public boolean isStableDestination(BlockPos pos) {
            return WaterWalking.canWalkOn(this.level.getFluidState(pos)) || super.isStableDestination(pos);
        }
    }
}

