/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive.monkey;

import com.google.common.base.Suppliers;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.tropicraft.core.common.BinaryAnimation;
import net.tropicraft.core.common.Easings;
import net.tropicraft.core.common.TropicraftTags;

public class SpiderMonkeyEntity
extends Animal {
    private static final Supplier<Ingredient> BREEDING_ITEMS = Suppliers.memoize(() -> Ingredient.of(TropicraftTags.Items.FRUITS));
    private static final EntityDataAccessor<Boolean> STANDING = SynchedEntityData.defineId(SpiderMonkeyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final BinaryAnimation standAnimation = new BinaryAnimation(15, Easings::inOutSine);

    public SpiderMonkeyEntity(EntityType<? extends SpiderMonkeyEntity> type, Level world) {
        super(type, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)BREEDING_ITEMS.get(), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STANDING, (Object)false);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.tickStandingState();
        } else {
            this.standAnimation.tick(this.isStanding());
        }
    }

    private void tickStandingState() {
        if (this.getLastHurtByMob() != null) {
            this.setStanding(false);
            return;
        }
        if (this.level().random.nextInt(200) == 0) {
            boolean standing = this.level().random.nextInt(3) == 0;
            this.setStanding(standing);
        }
    }

    public void setStanding(boolean standing) {
        this.entityData.set(STANDING, (Object)standing);
        this.standAnimation.setImmediate(standing);
    }

    public boolean isStanding() {
        return (Boolean)this.entityData.get(STANDING);
    }

    public float getStandAnimation(float partialTicks) {
        return this.standAnimation.get(partialTicks);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setStanding(nbt.getBoolean("standing"));
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("standing", this.isStanding());
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public SpiderMonkeyEntity getBreedOffspring(ServerLevel world, AgeableMob mate) {
        return null;
    }

    public int getMaxFallDistance() {
        return 5;
    }

    protected int calculateFallDamage(float distance, float damageMultiplier) {
        return super.calculateFallDamage(distance, damageMultiplier) / 2;
    }
}

