/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.placeable;

import com.tterrag.registrate.util.entry.ItemEntry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.item.AshenMasks;
import net.tropicraft.core.common.item.TropicraftItems;

public class AshenMaskEntity
extends Entity {
    private static final EntityDataAccessor<Byte> MASK_TYPE = SynchedEntityData.defineId(AshenMaskEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final int MAX_TICKS_ALIVE = 24000;

    public AshenMaskEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public void dropItemStack() {
        this.spawnAtLocation(new ItemStack((ItemLike)((ItemEntry)TropicraftItems.ASHEN_MASKS.get((Object)AshenMasks.VALUES[this.getMaskType()])).get()), 1.0f);
    }

    public boolean isPickable() {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(MASK_TYPE, (Object)0);
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        this.setMaskType(nbt.getByte("MaskType"));
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putByte("MaskType", this.getMaskType());
    }

    public void setMaskType(byte type) {
        this.entityData.set(MASK_TYPE, (Object)type);
    }

    public byte getMaskType() {
        return (Byte)this.entityData.get(MASK_TYPE);
    }

    public void tick() {
        if (!this.level().isClientSide && this.tickCount >= 24000) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        Vec3 motion = this.getDeltaMovement();
        if (this.onGround()) {
            this.setDeltaMovement(motion.multiply(0.5, 0.0, 0.5));
        }
        if (this.isInWater()) {
            this.setDeltaMovement(motion.x * (double)0.95f, 0.02f, motion.z * (double)0.95f);
        } else {
            this.setDeltaMovement(motion.subtract(0.0, (double)0.05f, 0.0));
        }
        this.move(MoverType.SELF, motion);
    }

    public boolean hurt(DamageSource damageSource, float par2) {
        if (this.isInvulnerableTo(damageSource)) {
            return false;
        }
        if (this.isAlive() && !this.level().isClientSide) {
            this.remove(Entity.RemovalReason.KILLED);
            this.markHurt();
            this.dropItemStack();
        }
        return true;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)((ItemEntry)TropicraftItems.ASHEN_MASKS.get((Object)AshenMasks.VALUES[this.getMaskType()])).get());
    }
}

