/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.placeable;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.tropicraft.core.common.entity.placeable.FurnitureEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class ChairEntity
extends FurnitureEntity {
    private static final EntityDataAccessor<Byte> COMESAILAWAY = SynchedEntityData.defineId(ChairEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public boolean isChairEmpty = true;
    private double speedMultiplier = 0.1;
    private float rotationDelta = 0.0f;
    private static final float ROTATION_SPEED = 2.5f;
    private static final float FRICTION = 0.05f;

    public ChairEntity(EntityType<ChairEntity> type, Level world) {
        super(type, world, TropicraftItems.CHAIRS);
    }

    @Override
    public void tick() {
        super.tick();
        double waterHeight = 0.0;
        if (this.getComeSailAway()) {
            waterHeight = this.findWaterHeight(waterHeight);
        }
        double speed = this.getDeltaMovement().length();
        if (this.getComeSailAway() && speed > 0.2625) {
            double forwardX = Math.cos(this.getYRot() * ((float)Math.PI / 180));
            double forwardZ = Math.sin(this.getYRot() * ((float)Math.PI / 180));
            int i = 0;
            while ((double)i < 1.0 + speed * 60.0) {
                double particleZ;
                double particleX;
                double d5 = this.random.nextFloat() * 2.0f - 1.0f;
                double d6 = (double)(this.random.nextInt(2) * 2 - 1) * 0.7;
                if (this.random.nextBoolean()) {
                    particleX = this.getX() - forwardX * d5 * 0.8 + forwardZ * d6;
                    particleZ = this.getZ() - forwardZ * d5 * 0.8 - forwardX * d6;
                } else {
                    particleX = this.getX() + forwardX + forwardZ * d5 * 0.7;
                    particleZ = this.getZ() + forwardZ - forwardX * d5 * 0.7;
                }
                this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, particleX, this.getY() - 0.125, particleZ, this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z);
                ++i;
            }
        }
        LivingEntity passenger = this.getControllingPassenger();
        if (!this.level().isClientSide || this.getComeSailAway()) {
            double newSpeed;
            if (waterHeight < 1.0) {
                double d2 = waterHeight * 2.0 - 1.0;
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.04 * d2, 0.0));
            } else {
                if (this.getDeltaMovement().y < 0.0) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.5, 1.0));
                }
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.007, 0.0));
            }
            if (this.getComeSailAway() && passenger != null) {
                float yRot = passenger.getYRot() + -passenger.xxa * 90.0f;
                double moveX = -Math.sin(yRot * ((float)Math.PI / 180)) * this.speedMultiplier * (double)passenger.zza * 0.05;
                double moveZ = Math.cos(yRot * ((float)Math.PI / 180)) * this.speedMultiplier * (double)passenger.zza * 0.05;
                this.setDeltaMovement(this.getDeltaMovement().add(moveX, 0.0, moveZ));
            }
            if ((newSpeed = this.getDeltaMovement().length()) > 0.45) {
                double friction = 0.45 / newSpeed;
                this.setDeltaMovement(this.getDeltaMovement().multiply(friction, 1.0, friction));
                newSpeed = 0.45;
            }
            if (newSpeed > speed && this.speedMultiplier < 0.45) {
                this.speedMultiplier += (0.45 - this.speedMultiplier) / 45.0;
                if (this.speedMultiplier > 0.45) {
                    this.speedMultiplier = 0.45;
                }
            } else {
                this.speedMultiplier -= (this.speedMultiplier - 0.1) / 45.0;
                if (this.speedMultiplier < 0.1) {
                    this.speedMultiplier = 0.1;
                }
            }
            if (this.getComeSailAway()) {
                for (int i = 0; i < 4; ++i) {
                    int x = Mth.floor((double)(this.getX() + ((double)(i % 2) - 0.5) * 0.8));
                    int z = Mth.floor((double)(this.getZ() + ((double)(i / 2) - 0.5) * 0.8));
                    for (int j1 = 0; j1 < 2; ++j1) {
                        int k = Mth.floor((double)this.getY()) + j1;
                        BlockPos pos = new BlockPos(x, k, z);
                        Block block = this.level().getBlockState(pos).getBlock();
                        if (block == Blocks.SNOW) {
                            this.level().destroyBlock(pos, true);
                            this.horizontalCollision = false;
                            continue;
                        }
                        if (block != Blocks.LILY_PAD) continue;
                        this.level().destroyBlock(pos, true);
                        this.horizontalCollision = false;
                    }
                }
            }
            if (this.onGround()) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 1.0, 0.5));
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            if (this.getComeSailAway()) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.99, 0.95, 0.99));
            }
            this.setXRot(0.0f);
            float targetYRot = this.getYRot();
            double deltaX = this.xo - this.getX();
            double deltaZ = this.zo - this.getZ();
            if (deltaX * deltaX + deltaZ * deltaZ > 0.001) {
                targetYRot = (float)(Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI);
            }
            double yRotStep = Mth.wrapDegrees((double)((double)targetYRot - (double)this.getYRot()));
            yRotStep = Mth.clamp((double)yRotStep, (double)-20.0, (double)20.0);
            this.setYRot((float)((double)this.getYRot() + yRotStep));
            this.setRot(this.getYRot(), this.getXRot());
            if (!this.level().isClientSide) {
                List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.2, 0.0, 0.2));
                for (Entity entity : entities) {
                    if (entity == passenger || !entity.isPushable() || !(entity instanceof ChairEntity)) continue;
                    entity.push((Entity)this);
                }
                if (passenger != null && !passenger.isAlive()) {
                    this.ejectPassengers();
                }
            }
        } else {
            this.move(MoverType.SELF, this.getDeltaMovement());
        }
        this.rotationDelta *= 0.05f;
        if (this.level().isClientSide && passenger instanceof Player) {
            Player controller = (Player)passenger;
            this.rotationDelta += -controller.xxa * 2.5f;
            this.setYRot(this.getYRot() + this.rotationDelta);
        }
    }

    private double findWaterHeight(double waterHeight) {
        AABB bounds = this.getBoundingBox();
        int steps = 5;
        for (int i = 0; i < steps; ++i) {
            double start = Mth.lerp((double)((double)i / (double)steps), (double)bounds.minY, (double)bounds.maxY) - 0.125;
            double end = Mth.lerp((double)((double)(i + 1) / (double)steps), (double)bounds.minY, (double)bounds.maxY) - 0.125;
            AABB testBounds = new AABB(bounds.minX, start, bounds.minZ, bounds.maxX, end, bounds.maxZ);
            if (!this.level().containsAnyLiquid(testBounds)) continue;
            waterHeight += 1.0 / (double)steps;
        }
        return waterHeight;
    }

    @Override
    protected boolean preventMotion() {
        return !this.getComeSailAway();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COMESAILAWAY, (Object)0);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setComeSailAway(nbt.getBoolean("COME_SAIL_AWAY"));
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("COME_SAIL_AWAY", this.getComeSailAway());
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.invulnerablityCheck(player, hand) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (!this.level().isClientSide && !player.isShiftKeyDown()) {
            player.startRiding((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return !player.isPassengerOfSameVehicle((Entity)this) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @Override
    public boolean isPickable() {
        return this.isAlive();
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity passenger;
        Entity entity = this.getFirstPassenger();
        return entity instanceof LivingEntity ? (passenger = (LivingEntity)entity) : null;
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction move) {
        super.positionRider(passenger, move);
        passenger.setYRot(passenger.getYRot() + this.rotationDelta);
        passenger.setYHeadRot(passenger.getYHeadRot() + this.rotationDelta);
    }

    public void setComeSailAway(boolean sail) {
        this.entityData.set(COMESAILAWAY, (Object)(sail ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0)));
    }

    public boolean getComeSailAway() {
        return (Byte)this.entityData.get(COMESAILAWAY) == 1;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.CHAIRS.get(DyeColor.byId((int)this.getColor().getId())).get());
    }

    public AABB getBoundingBoxForCulling() {
        return this.getBoundingBox().expandTowards(0.0, 1.0, 0.0);
    }
}

