/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class LavaBallEntity
extends Entity {
    public boolean setFire;
    public float size;
    public final boolean held;
    public int lifeTimer;
    public double accelerationX;
    public double accelerationY;
    public double accelerationZ;

    public LavaBallEntity(EntityType<? extends LavaBallEntity> type, Level world) {
        super(type, world);
        this.setFire = false;
        this.held = false;
        this.size = 1.0f;
        this.lifeTimer = 0;
    }

    public LavaBallEntity(EntityType<? extends LavaBallEntity> type, Level world, double i, double j, double k, double motX, double motY, double motZ) {
        super(type, world);
        this.setFire = false;
        this.moveTo(i, j, k, 0.0f, 0.0f);
        this.accelerationX = motX;
        this.accelerationY = motY;
        this.accelerationZ = motZ;
        this.size = 1.0f;
        this.held = false;
        this.lifeTimer = 0;
    }

    public LavaBallEntity(EntityType<? extends LavaBallEntity> type, Level world, float startSize) {
        super(type, world);
        this.size = startSize;
        this.setFire = false;
        this.held = true;
        this.lifeTimer = 0;
    }

    public boolean isPickable() {
        return true;
    }

    public boolean isPushable() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void supahDrip() {
        float x = (float)this.getX();
        float y = (float)this.getY();
        float z = (float)this.getZ();
        if (this.level().isClientSide) {
            this.level().addParticle((ParticleOptions)ParticleTypes.LAVA, (double)x, (double)y, (double)z, this.getDeltaMovement().x, -1.5, this.getDeltaMovement().z);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.lifeTimer < 500) {
            ++this.lifeTimer;
        } else {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        double motionX = this.getDeltaMovement().x;
        double motionY = this.getDeltaMovement().y;
        double motionZ = this.getDeltaMovement().z;
        if (this.size < 1.0f) {
            this.size = (float)((double)this.size + 0.025);
        }
        if (this.onGround()) {
            motionZ *= 0.95;
            motionX *= 0.95;
        }
        motionY *= 0.99;
        if (!this.onGround()) {
            motionY -= (double)0.05f;
            if (this.level().isClientSide) {
                for (int i = 0; i < 5 + this.random.nextInt(3); ++i) {
                    this.supahDrip();
                }
            }
        }
        if (this.horizontalCollision) {
            motionZ = 0.0;
            motionX = 0.0;
        }
        int thisX = (int)Math.floor(this.getX());
        int thisY = (int)Math.floor(this.getY());
        int thisZ = (int)Math.floor(this.getZ());
        BlockPos posCurrent = new BlockPos(thisX, thisY, thisZ);
        BlockPos posBelow = posCurrent.below();
        BlockState stateBelow = this.level().getBlockState(posBelow);
        if (!(stateBelow.isAir() || stateBelow.is(Blocks.LAVA) || this.held)) {
            if (this.setFire) {
                this.level().setBlock(posCurrent, Blocks.LAVA.defaultBlockState(), 3);
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            if (!this.setFire) {
                if (this.level().isEmptyBlock(posCurrent.west())) {
                    this.level().setBlock(posCurrent.west(), Blocks.LAVA.defaultBlockState(), 2);
                }
                if (this.level().isEmptyBlock(posCurrent.east())) {
                    this.level().setBlock(posCurrent.east(), Blocks.LAVA.defaultBlockState(), 2);
                }
                if (this.level().isEmptyBlock(posCurrent.south())) {
                    this.level().setBlock(posCurrent.south(), Blocks.LAVA.defaultBlockState(), 2);
                }
                if (this.level().isEmptyBlock(posCurrent.north())) {
                    this.level().setBlock(posCurrent.north(), Blocks.LAVA.defaultBlockState(), 2);
                }
                this.level().setBlock(posCurrent, Blocks.LAVA.defaultBlockState(), 3);
                this.setFire = true;
            }
        }
        Vec3 motion = new Vec3(motionX + this.accelerationX, motionY + this.accelerationY, motionZ + this.accelerationZ);
        this.setDeltaMovement(motion);
        this.move(MoverType.SELF, motion);
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        this.lifeTimer = nbt.getInt("lifeTimer");
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putInt("lifeTimer", this.lifeTimer);
    }
}

