/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.tropicraft.core.common.sound.Sounds;

public class TropicraftDolphinEntity
extends Dolphin {
    private static final EntityDataAccessor<Boolean> MOUTH_OPEN = SynchedEntityData.defineId(TropicraftDolphinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> TEXTURE_NAME = SynchedEntityData.defineId(TropicraftDolphinEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public TropicraftDolphinEntity(EntityType<? extends TropicraftDolphinEntity> type, Level world) {
        super(type, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MOUTH_OPEN, (Object)false);
        builder.define(TEXTURE_NAME, (Object)"dolphin");
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        this.setTexture(this.random.nextInt(50) == 0 ? "special_dolphin" : "dolphin");
        return super.finalizeSpawn(world, difficultyInstance, spawnReason, entityData);
    }

    public void setTexture(String textureName) {
        this.getEntityData().set(TEXTURE_NAME, (Object)textureName);
    }

    public String getTexture() {
        return (String)this.getEntityData().get(TEXTURE_NAME);
    }

    public void setMouthOpen(boolean b) {
        this.getEntityData().set(MOUTH_OPEN, (Object)b);
    }

    public boolean getMouthOpen() {
        return (Boolean)this.getEntityData().get(MOUTH_OPEN);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString("Texture", this.getTexture());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setTexture(nbt.getString("Texture"));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.ambientSoundTime < -(this.getAmbientSoundInterval() - 20)) {
                if (this.tickCount % 3 > 1) {
                    if (!this.getMouthOpen()) {
                        this.setMouthOpen(true);
                    }
                } else if (this.getMouthOpen()) {
                    this.setMouthOpen(false);
                }
            } else if (this.getMouthOpen()) {
                this.setMouthOpen(false);
            }
        }
    }

    public int getAmbientSoundInterval() {
        return 300;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)Sounds.DOLPHIN.get();
    }
}

