/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.tropicraft.core.client.data.TropicraftLangKeys;
import net.tropicraft.core.common.TropicsConfigs;
import net.tropicraft.core.common.entity.projectile.ExplodingCoconutEntity;
import net.tropicraft.core.common.item.TropicraftDataComponents;

public class ExplodingCoconutItem
extends Item {
    public ExplodingCoconutItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean canPlayerThrow;
        ItemStack item = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)item);
        }
        float explosionRadius = ((Float)item.getOrDefault(TropicraftDataComponents.EXPLOSION_RADIUS, (Object)Float.valueOf(2.4f))).floatValue();
        boolean destroysBlocks = (Boolean)item.getOrDefault(TropicraftDataComponents.DESTROYS_BLOCKS, (Object)true);
        boolean requiresPermission = explosionRadius > 0.0f && destroysBlocks;
        boolean bl = canPlayerThrow = player.isCreative() || player.canUseGameMasterBlocks() || (Boolean)TropicsConfigs.COMMON.allowExplodingCoconutsByNonOPs.get() != false;
        if (requiresPermission && !canPlayerThrow) {
            player.displayClientMessage(TropicraftLangKeys.EXPLODING_COCONUT_WARNING.component(), false);
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)item);
        }
        ExplodingCoconutEntity coconut = new ExplodingCoconutEntity(level, (LivingEntity)player, explosionRadius, destroysBlocks);
        coconut.setItem(item);
        coconut.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
        level.addFreshEntity((Entity)coconut);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (player.getRandom().nextFloat() * 0.4f + 0.8f));
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        item.consume(1, (LivingEntity)player);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)item);
    }
}

