/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.tropicraft.core.common.entity.placeable.WallItemEntity;

public class ShellItem
extends Item {
    public ShellItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Direction facing = context.getClickedFace();
        ItemStack stack = context.getPlayer().getItemInHand(context.getHand());
        BlockPos pos = context.getClickedPos().relative(facing);
        Level world = context.getLevel();
        WallItemEntity hangingEntity = new WallItemEntity(world, pos, facing);
        hangingEntity.setItem(stack);
        if (!context.getPlayer().mayUseItemAt(pos, facing, stack)) {
            return InteractionResult.FAIL;
        }
        if (hangingEntity.survives()) {
            if (!world.isClientSide) {
                world.addFreshEntity((Entity)hangingEntity);
            }
            stack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }
}

